/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.SpaceStation.Flameborn;

import java.util.List;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.BigAnnihilationSweepParticle;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.SpaceStation.Flameborn.FlamebornGuardBlockGoal;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.AbstractChorusling;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.AbstractFlameborn;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationFlameStrike;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.tag.ModEntityTags;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class FlamebornGuardEntity
extends AbstractFlameborn {
    public final int BLOCK_COOLDOWN = 60;
    public int block_cooldown = 60;
    public int SweepType = 1;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState SweepAnimationState = new AnimationState();
    public AnimationState SweepSlamAnimationState = new AnimationState();
    public AnimationState DoubleSweepAnimationState = new AnimationState();
    public AnimationState BlockAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public int deathTime;

    public FlamebornGuardEntity(EntityType entity, Level world) {
        super(entity, world);
        this.m_21530_();
        this.f_21364_ = 5;
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_) {
            if (this.isDuringTeleportation() && !this.m_20145_()) {
                this.m_6842_(true);
            } else if (!this.isDuringTeleportation() && this.m_20145_()) {
                this.m_6842_(false);
            }
        }
        if (this.block_cooldown > 0) {
            --this.block_cooldown;
        }
        this.idleAnimationState.m_246184_(this.getAttackState() == 0, this.f_19797_);
        super.m_8119_();
    }

    public boolean isDuringTeleportation() {
        return this.getAttackState() == 4 && this.attackTicks > 9 && this.attackTicks < 15;
    }

    public void m_8107_() {
        this.updateWithAttack();
        super.m_8107_();
    }

    public void updateWithAttack() {
        float sweepSize = 1.25f;
        float sweepRot = 0.0f;
        float uRange = 3.25f;
        if (this.getAttackState() == 2) {
            if (this.attackTicks == 13) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.25f);
                this.calculatedDash(0.2f);
            }
            if (this.attackTicks == 14) {
                this.createSweep(0.0f, 0.0f, 3.0f, true, sweepSize, sweepRot);
            }
            if (this.attackTicks == 16) {
                this.SideAreaAttack(uRange, 3.0f, 180.0f, 0.0f, 0.0f, 12.0f, 30, false, false, SoundEvents.f_12600_, 0.75f);
            }
        }
        if (this.getAttackState() == 3) {
            for (int i = 35; i <= 39; i += 2) {
                if (this.attackTicks != i) continue;
                int d = i - 34;
                this.flameRadagonShockwave(0.25f, d, 1.5f, 2, 0.0f, 0.0f);
            }
            if (this.attackTicks == 13) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.25f);
                this.calculatedDash(0.2f);
            }
            if (this.attackTicks == 14) {
                this.createSweep(0.0f, 0.0f, 3.0f, true, sweepSize, sweepRot);
            }
            if (this.attackTicks == 16) {
                this.SideAreaAttack(uRange, 3.0f, 180.0f, 0.0f, 0.0f, 12.0f, 30, false, false, SoundEvents.f_12600_, 0.75f);
            }
            if (this.attackTicks == 25 || this.attackTicks == 27) {
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            if (this.attackTicks == 37) {
                this.StraightLineAreaAttack(0.025f, 4.0f, 80, 14.0f, false);
                this.m_5496_(SoundEvents.f_11892_, 1.0f, 1.0f);
                this.spawnCircleParticle(2.0f, 0.0f, 20.0f, true, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f);
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 15) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.25f);
                this.calculatedDash(0.2f);
            }
            if (this.attackTicks == 16) {
                this.createSweep(0.0f, 0.0f, 3.0f, false, sweepSize, sweepRot);
            }
            if (this.attackTicks == 18) {
                this.SideAreaAttack(uRange, 3.0f, 180.0f, 0.0f, 0.0f, 12.0f, 30, false, false, SoundEvents.f_12600_, 0.75f);
            }
            if (this.attackTicks == 28) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.25f);
                this.calculatedDash(0.2f);
            }
            if (this.attackTicks == 29) {
                this.createSweep(0.0f, 0.0f, 3.0f, true, sweepSize, sweepRot);
            }
            if (this.attackTicks == 31) {
                this.SideAreaAttack(uRange, 3.0f, 180.0f, 0.0f, 0.0f, 12.0f, 30, false, false, SoundEvents.f_12600_, 0.75f);
            }
        }
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_6095_().m_204039_(ModEntityTags.ANNIHILATION_TEAM) || super.m_7307_(pEntity);
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractChorusling.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 2, 0, 40, 35, 3.5f){

            @Override
            public void m_8041_() {
                FlamebornGuardEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlamebornGuardEntity.this.m_217043_().m_188501_() * 100.0f < 20.0f && FlamebornGuardEntity.this.m_5448_() != null && FlamebornGuardEntity.this.getNextSweepType() == 1;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 60, 50, 3.5f){

            @Override
            public void m_8041_() {
                FlamebornGuardEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlamebornGuardEntity.this.m_217043_().m_188501_() * 100.0f < 16.0f && FlamebornGuardEntity.this.m_5448_() != null;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new FlamebornGuardBlockGoal(this, 4, 4, 0, 26, 26){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                FlamebornGuardEntity.this.randomizeAttacks();
                FlamebornGuardEntity.this.block_cooldown = 60;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 6, 6, 0, 60, 0){

            @Override
            public void m_8041_() {
                FlamebornGuardEntity.this.randomizeAttacks();
                super.m_8041_();
            }
        });
    }

    public void randomizeAttacks() {
        this.randomizeNextSweepType(2);
    }

    public int getNextSweepType() {
        return this.SweepType;
    }

    public void randomizeNextSweepType(int rolls) {
        switch (this.f_19796_.m_188503_(rolls)) {
            case 0: {
                this.SweepType = 1;
                break;
            }
            case 1: {
                this.SweepType = 2;
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 10.0);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sweep_slam") {
            return this.SweepSlamAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "sweep") {
            return this.SweepAnimationState;
        }
        if (input == "block") {
            return this.BlockAnimationState;
        }
        if (input == "double_sweep") {
            return this.DoubleSweepAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.SweepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.SweepSlamAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.BlockAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.DoubleSweepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.SweepAnimationState.m_216973_();
        this.SweepSlamAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.BlockAnimationState.m_216973_();
        this.DoubleSweepAnimationState.m_216973_();
    }

    public void onAddedToWorld() {
        EntityUtil.applyHealthMultiplier((LivingEntity)this, (Double)ModConfig.MOB_CONFIG.FlamebornGuardHealthMultiplier.get());
        super.onAddedToWorld();
    }

    @Override
    public int attackDelayTicksValue() {
        return this.block_cooldown <= 0 ? 3 : 0;
    }

    public void SideAreaAttack(float range, float height, float arc, float boxOffset, float forwardOffset, float damage, int brokenShieldTicks, boolean canStun, boolean canlaunch, SoundEvent soundEvent, float pitch) {
        double theta = Math.toRadians(this.f_20883_) + 1.5707963267948966;
        double forwardX = Math.cos(theta) * (double)forwardOffset;
        double forwardZ = Math.sin(theta) * (double)forwardOffset;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityAttackingAngle;
            double dx = entityHit.m_20185_() - (this.m_20185_() + forwardX);
            double dz = entityHit.m_20189_() - (this.m_20189_() + forwardZ);
            float entityHitAngle = (float)((Math.toDegrees(Math.atan2(dz, dx)) - 90.0) % 360.0);
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if ((entityAttackingAngle = (this.f_20883_ - boxOffset) % 360.0f) < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityHitDistance = (float)Math.sqrt(dx * dx + dz * dz);
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof TheObliteratorEntity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.FlamebornGuardDamageMutliplier.get()));
            if (flag) {
                this.m_5496_(soundEvent, 1.0f, pitch);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            FlamebornGuardEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    private void StraightLineAreaAttack(float boxWidth, float range, int brokenShieldTicks, float damage, boolean launch) {
        double rad = Math.toRadians(this.m_146908_() + 90.0f);
        double xRange = (double)range * Math.cos(rad);
        double zRange = (double)range * Math.sin(rad);
        AABB attackRange = this.m_20191_().m_82377_((double)boxWidth, 3.5, (double)boxWidth).m_82363_(xRange, 0.0, zRange);
        for (LivingEntity entityHit : this.m_9236_().m_45976_(LivingEntity.class, attackRange)) {
            if (this.m_7307_((Entity)entityHit) || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.FlamebornGuardDamageMutliplier.get()));
            if (flag && launch) {
                this.launch(entityHit, true);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            FlamebornGuardEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    public boolean canBlock() {
        return this.getAttackState() == 0 && this.block_cooldown <= 0 && !this.m_9236_().f_46443_ && this.m_5448_() != null;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getAttackState() == 3 && this.attackTicks >= 25 && this.attackTicks <= 27 || this.getAttackState() == 4 && this.attackTicks < 15) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            this.m_5496_(SoundEvents.f_12418_, 1.0f, 1.0f);
            this.teleportRandomly((LivingEntity)this, 8.0f, 10.0f);
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        amount *= 0.75f;
        if (this.canBlock() && amount > 1.0f) {
            this.setAttackState(4);
            this.m_5496_((SoundEvent)ModSounds.BLOCK.get(), 1.0f, 1.25f);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean teleport(double x, double y, double z) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.TELEPORT_EFFECT.get()), this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        if (flag) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.teleportBoolean(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    // empty if block
                }
            }
            return flag2;
        }
        return false;
    }

    public void m_6667_(DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        this.deathTime = 0;
        this.setAttackState(6);
        this.stopAllAnimationStates();
    }

    @Override
    public boolean teleportBoolean(double x, double y, double z, boolean p_20988_) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        double d3 = y;
        boolean flag = false;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        Level level = this.m_9236_();
        if (level.m_46805_(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.m_123342_() > level.m_141937_()) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = level.m_8055_(blockpos1);
                if (blockstate.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.m_6021_(x, d3, z);
                if (level.m_45786_((Entity)this) && !level.m_46855_(this.m_20191_())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.m_6021_(d0, d1, d2);
            return false;
        }
        if (p_20988_) {
            level.m_7605_((Entity)this, (byte)46);
        }
        this.m_21573_().m_26573_();
        return true;
    }

    public void createSweep(float pos, float posOffset, float yHeight, boolean reverse, float scale, float rot) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float vec = pos;
        float offset = posOffset;
        double x = this.m_20185_() + (double)vec * vecX + (double)(f * offset);
        double z = this.m_20189_() + (double)vec * vecZ + (double)(f1 * offset);
        if (this.m_9236_().f_46443_) {
            double d0 = x;
            double d1 = this.m_20186_() + (double)(this.m_20206_() / 2.0f) + 0.4;
            double d2 = z;
            float yaw = (float)Math.toRadians(-this.f_20883_ + (reverse ? rot : 180.0f));
            double lookX = -Math.cos(yaw);
            double lookZ = -Math.sin(yaw);
            float pitch = (float)(reverse ? -1 : 1) * (float)Math.atan2(yHeight, Math.sqrt(lookX * lookX + lookZ * lookZ));
            this.m_9236_().m_7106_((ParticleOptions)new BigAnnihilationSweepParticle.SweepData(this.m_6134_() * scale, yaw, pitch), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11849_;
    }

    private void flameRadagonShockwave(float spreadarc, int distance, float vec, int delay, float pos, float offset) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta1 = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta1 += 1.5707963267948966);
        double vecZ = Math.sin(theta1);
        int floor = Mth.m_14107_((double)this.m_20186_());
        double x = this.m_20185_() + (double)pos * vecX + (double)(f * offset);
        double z = this.m_20189_() + (double)pos * vecZ + (double)(f1 * offset);
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = x + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = z + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            this.spawnFlames((double)hitX + 0.5, (double)hitZ + 0.5, this.m_20186_() - 5.0, this.m_20186_() + 3.0, (float)theta, delay, 7.0f);
        }
    }

    private void spawnFlames(double x, double z, double minY, double maxY, float rotation, int delay, float damage) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            FlamebornGuardEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new AnnihilationFlameStrike(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)this, 20, 5.0f));
        }
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime == 60) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }
}

