/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.SpaceStation.Flameborn;

import java.util.List;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.AbstractChorusling;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.AbstractFlameborn;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IStateGoal;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.tag.ModEntityTags;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class FlamebornWarriorEntity
extends AbstractFlameborn {
    public int HitType = 1;
    public int DoubleHitType = 1;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState HitAnimationState = new AnimationState();
    public AnimationState Hit2AnimationState = new AnimationState();
    public AnimationState HitDoubleAnimationState = new AnimationState();
    public AnimationState HitDouble2AnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public int deathTime;

    public FlamebornWarriorEntity(EntityType entity, Level world) {
        super(entity, world);
        this.m_21530_();
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_6095_().m_204039_(ModEntityTags.ANNIHILATION_TEAM) || super.m_7307_(pEntity);
    }

    @Override
    public void m_8119_() {
        if (this.m_9236_().f_46443_) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0, this.f_19797_);
        }
        super.m_8119_();
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_269533_(DamageTypeTags.f_268524_)) {
            this.m_5496_(SoundEvents.f_12418_, 1.0f, 1.0f);
            this.teleportRandomly((LivingEntity)this, 8.0f, 10.0f);
            return false;
        }
        if (pSource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractChorusling.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 2, 0, 49, 49, 3.5f){

            @Override
            public void m_8041_() {
                FlamebornWarriorEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlamebornWarriorEntity.this.m_217043_().m_188501_() * 100.0f < 20.0f && FlamebornWarriorEntity.this.m_5448_() != null && FlamebornWarriorEntity.this.getNextHitType() == 1;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 49, 49, 3.5f){

            @Override
            public void m_8041_() {
                FlamebornWarriorEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlamebornWarriorEntity.this.m_217043_().m_188501_() * 100.0f < 20.0f && FlamebornWarriorEntity.this.m_5448_() != null && FlamebornWarriorEntity.this.getNextHitType() == 2;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 62, 62, 3.5f){

            @Override
            public void m_8041_() {
                FlamebornWarriorEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlamebornWarriorEntity.this.m_217043_().m_188501_() * 100.0f < 20.0f && FlamebornWarriorEntity.this.m_5448_() != null && FlamebornWarriorEntity.this.getNextDoubleHitType() == 1;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 62, 62, 3.5f){

            @Override
            public void m_8041_() {
                FlamebornWarriorEntity.this.randomizeAttacks();
                super.m_8041_();
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && FlamebornWarriorEntity.this.m_217043_().m_188501_() * 100.0f < 20.0f && FlamebornWarriorEntity.this.m_5448_() != null && FlamebornWarriorEntity.this.getNextDoubleHitType() == 2;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IStateGoal(this, 6, 6, 0, 60, 0){

            @Override
            public void m_8041_() {
                FlamebornWarriorEntity.this.randomizeAttacks();
                super.m_8041_();
            }
        });
    }

    public void randomizeAttacks() {
        this.randomizeNextDoubleHitType(2);
        this.randomizeNextHitType(2);
    }

    public int getNextHitType() {
        return this.HitType;
    }

    public void randomizeNextHitType(int rolls) {
        switch (this.f_19796_.m_188503_(rolls)) {
            case 0: {
                this.HitType = 1;
                break;
            }
            case 1: {
                this.HitType = 2;
            }
        }
    }

    public int getNextDoubleHitType() {
        return this.DoubleHitType;
    }

    public void randomizeNextDoubleHitType(int rolls) {
        switch (this.f_19796_.m_188503_(rolls)) {
            case 0: {
                this.DoubleHitType = 1;
                break;
            }
            case 1: {
                this.DoubleHitType = 2;
            }
        }
    }

    public void UpdateWithAttack() {
        float range = 2.5f;
        float dash = 0.25f;
        if (this.getAttackState() == 2 || this.getAttackState() == 3) {
            if (this.attackTicks == 13) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
                this.calculatedDash(dash);
            }
            if (this.attackTicks == 16) {
                this.SideAreaAttack(range, 2.0f, 180.0f, 0.0f, 0.0f, 12.0f, 0, SoundEvents.f_12600_, 1.0f);
            }
        }
        if (this.getAttackState() == 4 || this.getAttackState() == 5) {
            if (this.attackTicks == 13) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
                this.calculatedDash(dash);
            }
            if (this.attackTicks == 16) {
                this.SideAreaAttack(range, 2.0f, 180.0f, 0.0f, 0.0f, 12.0f, 0, SoundEvents.f_12600_, 1.0f);
            }
            if (this.attackTicks == 31) {
                this.m_5496_((SoundEvent)ModSounds.GENERIC_ARM_SWING.get(), 1.0f, 1.0f);
                this.calculatedDash(dash - 0.05f);
            }
            if (this.attackTicks == 34) {
                this.SideAreaAttack(range, 4.0f, 180.0f, 0.0f, 0.0f, 12.0f, 0, SoundEvents.f_12600_, 1.0f);
            }
        }
    }

    public void m_8107_() {
        this.UpdateWithAttack();
        super.m_8107_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, (double)0.3f).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 10.0);
    }

    public void SideAreaAttack(float range, float height, float arc, float boxOffset, float forwardOffset, float damage, int brokenShieldTicks, SoundEvent soundEvent, float pitch) {
        double theta = Math.toRadians(this.f_20883_) + 1.5707963267948966;
        double forwardX = Math.cos(theta) * (double)forwardOffset;
        double forwardZ = Math.sin(theta) * (double)forwardOffset;
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityAttackingAngle;
            double dx = entityHit.m_20185_() - (this.m_20185_() + forwardX);
            double dz = entityHit.m_20189_() - (this.m_20189_() + forwardZ);
            float entityHitAngle = (float)((Math.toDegrees(Math.atan2(dz, dx)) - 90.0) % 360.0);
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if ((entityAttackingAngle = (this.f_20883_ - boxOffset) % 360.0f) < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityHitDistance = (float)Math.sqrt(dx * dx + dz * dz);
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            if (!(entityHitDistance <= range) || !(entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof TheObliteratorEntity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.FlamebornGuardDamageMutliplier.get()));
            if (flag) {
                this.m_5496_(soundEvent, 1.0f, pitch);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || brokenShieldTicks <= 0) continue;
            FlamebornWarriorEntity.disableShield(entityHit, brokenShieldTicks);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "hit2") {
            return this.Hit2AnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "hit") {
            return this.HitAnimationState;
        }
        if (input == "hit_double2") {
            return this.HitDouble2AnimationState;
        }
        if (input == "hit_double") {
            return this.HitDoubleAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.HitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.Hit2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.HitDoubleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.HitDouble2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.HitAnimationState.m_216973_();
        this.Hit2AnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.HitDouble2AnimationState.m_216973_();
        this.HitDoubleAnimationState.m_216973_();
    }

    public void m_6667_(DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        this.deathTime = 0;
        this.setAttackState(6);
        this.stopAllAnimationStates();
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime == 60) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }
}

