/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs;

import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.ai.Warped_FungussusAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.jetbrains.annotations.Nullable;

public class Warped_FungussusEntity
extends Monster
implements IForgeEntity {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Warped_FungussusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public int dragonDeathTime;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 60;

    public Warped_FungussusEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 4;
        this.m_21557_(false);
    }

    public boolean m_5825_() {
        return true;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.DeathAnimationState.m_216984_()) {
            --this.DeathAnimationTimeout;
            if (this.DeathAnimationTimeout <= 0) {
                this.DeathAnimationState.m_216973_();
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.DeathAnimationTimeout >= 60) {
            if (this.dragonDeathTime > 0 && !this.DeathAnimationState.m_216984_()) {
                this.DeathAnimationState.m_216977_(this.f_19797_);
                --this.DeathAnimationTimeout;
                this.stopAllOtherAnimations();
            }
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.f_19796_.m_188503_(80) + 80;
                this.idleAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
            if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
                this.attackAnimationTimeout = 29;
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                --this.attackAnimationTimeout;
            }
            if (!this.isAttacking() && this.attackAnimationTimeout <= 0) {
                this.attackAnimationState.m_216973_();
            }
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Warped_FungussusAttackGoal((PathfinderMob)this, 3.0, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 7.0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            // empty if block
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    protected boolean canDespawn() {
        return true;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.dragonDeathTime = 0;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        EntityUtil.applyHealthMultiplier((LivingEntity)this, (Double)ModConfig.MOB_CONFIG.WarpedFungussusHealthMultiplier.get());
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268546_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.dragonDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    private void stopAllOtherAnimations() {
        this.attackAnimationState.m_216973_();
    }
}

