/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses;

import net.miauczel.legendary_monsters.LegendaryMonsters;
import net.miauczel.legendary_monsters.Message.PlayBossMusicMessage;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class IAnimatedBoss
extends IAnimatedMonster {
    private static final EntityDataAccessor<BlockPos> SPAWN_POS = SynchedEntityData.m_135353_(IAnimatedMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public final int REDUCED_DAMAGE_TICKS = 100;
    public final int DAMAGE_ADAPTATION_TICKS = 30;
    public int reducedDamageTicks = 100;
    public int damageAdaptationTicks = 30;
    public final int INACTIVE_TICKS = 260;
    public final int RETURN_TO_SPAWN_TICKS = 100;
    public int inActiveTicks = 260;
    public int return_to_spawn_ticks = 100;
    public int damageTimeFactor = 100;

    public IAnimatedBoss(EntityType entity, Level world) {
        super(entity, world);
        this.m_274367_(1.5f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWN_POS, (Object)BlockPos.f_121853_);
    }

    public void m_7378_(CompoundTag pCompound) {
        float x = pCompound.m_128451_("posX");
        float y = pCompound.m_128451_("posY");
        float z = pCompound.m_128451_("posZ");
        BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
        this.setSpawnBlockPos(blockPos);
        super.m_7378_(pCompound);
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("posX", this.getSpawnBlockPos().m_123341_());
        pCompound.m_128405_("posY", this.getSpawnBlockPos().m_123342_());
        pCompound.m_128405_("posZ", this.getSpawnBlockPos().m_123343_());
        super.m_7380_(pCompound);
    }

    public BlockPos getSpawnBlockPos() {
        return (BlockPos)this.f_19804_.m_135370_(SPAWN_POS);
    }

    public void setSpawnBlockPos(BlockPos blockPos) {
        this.f_19804_.m_135381_(SPAWN_POS, (Object)blockPos);
    }

    @Override
    public void m_8119_() {
        if (this.targetIsNotNull()) {
            this.inActiveTicks = 260;
        }
        if (this.return_to_spawn_ticks > 0 && this.inActiveTicks <= 0 && this.getSpawnBlockPos().m_203193_((Position)this.m_20182_()) >= 225.0) {
            --this.return_to_spawn_ticks;
        }
        if (this.reducedDamageTicks > 0) {
            --this.reducedDamageTicks;
        }
        if (this.damageAdaptationTicks > 0) {
            --this.damageAdaptationTicks;
        }
        if (this.damageAdaptationTicks == 0) {
            this.setDamageTimeFactor(100);
        }
        if (this.m_5448_() == null && !this.m_9236_().f_46443_ && this.inActiveTicks > 0) {
            --this.inActiveTicks;
        }
        if (this.inActiveTicks <= 0 && this.return_to_spawn_ticks <= 0 && !this.m_9236_().f_46443_ && this.getSpawnBlockPos().m_203193_((Position)this.m_20182_()) >= 225.0) {
            this.moveToBlockPos(this.getSpawnBlockPos());
            this.return_to_spawn_ticks = 100;
        }
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            if (this.canPlayMusic() && this.getBossMusic() != null) {
                LegendaryMonsters.sendMSGToAll(new PlayBossMusicMessage(this.m_19879_(), true));
            } else {
                LegendaryMonsters.sendMSGToAll(new PlayBossMusicMessage(this.m_19879_(), false));
            }
        }
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setSpawnBlockPos(this.m_20183_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public double damageCap() {
        return 21.0;
    }

    public float damageReduction() {
        return 1.0f;
    }

    public double healthMult() {
        return 1.0;
    }

    public double damageMult() {
        return 1.0;
    }

    public double baseDamage() {
        return 10.0;
    }

    public double baseHealth() {
        return 20.0;
    }

    public void moveToBlockPos(BlockPos blockPos) {
        this.m_20035_(blockPos, this.m_146908_(), this.m_146909_());
    }

    public boolean m_147207_(MobEffectInstance pEffectInstance, @javax.annotation.Nullable Entity pEntity) {
        return false;
    }

    public double antiCheeseDistance() {
        return 15.0;
    }

    public static float entityBasedHpDamage(LivingEntity entity, float precentage) {
        return entity.m_21233_() * MathUtils.toPrecent(precentage);
    }

    public static float toPrecent(float precentage) {
        return (float)((double)precentage * 0.01);
    }

    public boolean damageReductionSystem() {
        return false;
    }

    public boolean damageAdaptationSystem() {
        return false;
    }

    public int adaptationFactor() {
        return 10;
    }

    public int DamageTime() {
        return this.damageTimeFactor;
    }

    public void setDamageTimeFactor(int amount) {
        this.damageTimeFactor = amount;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268722_) || source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (this.damageReductionSystem()) {
            if (this.reducedDamageTicks <= 0) {
                this.reducedDamageTicks = 100;
            }
            if (!(source.m_269533_(DamageTypeTags.f_268738_) && source.m_269533_(DamageTypeTags.f_268490_) || this.reducedDamageTicks <= 0 || !this.damageReductionSystem())) {
                amount *= this.damageReduction();
            }
        }
        if (!this.damageReductionSystem() && this.damageAdaptationSystem()) {
            this.damageAdaptationTicks = 30;
            this.damageTimeFactor -= this.adaptationFactor();
            amount *= Mth.m_14036_((float)IAnimatedBoss.toPrecent(this.DamageTime()), (float)0.5f, (float)amount);
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        amount = (float)Math.min(this.damageCap(), (double)amount);
        if (this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) > this.antiCheeseDistance() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        boolean hurt1 = super.m_6469_(source, amount);
        return hurt1;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 100.0f;
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    public SoundEvent getBossMusic() {
        return null;
    }
}

