/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses;

import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMob;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class IAnimatedMiniBoss
extends IAnimatedMob {
    public final int REDUCED_DAMAGE_TICKS = 100;
    public int reducedDamageTicks = 100;
    public final int TICKS_WITHOUT_TARGET = 60;
    public int ticksWithoutTarget = 60;

    public IAnimatedMiniBoss(EntityType entity, Level world) {
        super(entity, world);
    }

    public void regainHealthWithoutTarget(float health, float speed) {
        if (((Boolean)ModConfig.MOB_CONFIG.AllowBossNatureHeal.get()).booleanValue() && !this.m_9236_().f_46443_) {
            if (!this.targetIsNotNull() && this.ticksWithoutTarget > 0 && this.getAttackState() == 0) {
                --this.ticksWithoutTarget;
            }
            if (this.ticksWithoutTarget <= 0 && !this.targetIsNotNull() && (float)this.f_19797_ % speed == 0.0f) {
                this.m_5634_(health);
            }
            if (this.targetIsNotNull()) {
                this.ticksWithoutTarget = 60;
            }
        }
    }

    @Override
    public void m_8119_() {
        if (this.reducedDamageTicks > 0) {
            --this.reducedDamageTicks;
        }
        this.regainHealthWithoutTarget(20.0f, 15.0f);
        super.m_8119_();
    }

    public double damageCap() {
        return 21.0;
    }

    public float damageReduction() {
        return 1.0f;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.isTargetCheesing(-4.0f, 4.0f)) {
            return false;
        }
        if (this.reducedDamageTicks <= 0) {
            this.reducedDamageTicks = 100;
        }
        if ((pSource.m_269533_(DamageTypeTags.f_268738_) || !pSource.m_276093_(DamageTypes.f_268515_)) && this.reducedDamageTicks > 0) {
            pAmount *= this.damageReduction();
        }
        if (pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(pSource, pAmount);
        }
        pAmount = (float)Math.min(this.damageCap(), (double)pAmount);
        return super.m_6469_(pSource, pAmount);
    }
}

