/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorUtils;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationExplosionEntity;
import net.miauczel.legendary_monsters.entity.client.ControlledAnim;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class AnnihilationBeamEntity
extends Entity {
    public double RADIUS;
    public LivingEntity caster;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float renderYaw;
    public float renderPitch;
    public ControlledAnim appear;
    public ControlledAnim appearVisual;
    public ControlledAnim disappear;
    public boolean on;
    public Direction blockSide;
    private static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HEAD = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FIRE = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> B_RADIUS = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HPDAMAGE = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ADDITIONAL_ROTATION = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> RIGHT_TURN_FIRST = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PRECENTAGE = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> FOLLOW_SPEED = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_QUAD = SynchedEntityData.m_135353_(AnnihilationBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float prevYaw;
    public float prevPitch;
    @OnlyIn(value=Dist.CLIENT)
    private Vec3[] attractorPos;
    public int NextSound;

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(B_RADIUS, (Object)Float.valueOf(radius));
    }

    public void setDelay(int delay) {
        this.f_19804_.m_135381_(DELAY, (Object)delay);
    }

    public int getDelay() {
        return (Integer)this.f_19804_.m_135370_(DELAY);
    }

    public void setFollowSpeed(float followSpeed) {
        this.f_19804_.m_135381_(FOLLOW_SPEED, (Object)Float.valueOf(followSpeed));
    }

    public float getAdditionalRotation() {
        return ((Float)this.f_19804_.m_135370_(ADDITIONAL_ROTATION)).floatValue();
    }

    public void setAdditionalRotation(float additionalRotation) {
        this.f_19804_.m_135381_(ADDITIONAL_ROTATION, (Object)Float.valueOf(additionalRotation));
    }

    public float getTurnBackPrecentage() {
        return ((Float)this.f_19804_.m_135370_(PRECENTAGE)).floatValue();
    }

    public void setTurnBackPrecentage(float additionalRotation) {
        this.f_19804_.m_135381_(PRECENTAGE, (Object)Float.valueOf(additionalRotation));
    }

    public float getFollowSpeed() {
        return ((Float)this.f_19804_.m_135370_(FOLLOW_SPEED)).floatValue();
    }

    public void setIsQuad(boolean isQuad) {
        this.f_19804_.m_135381_(IS_QUAD, (Object)isQuad);
    }

    public boolean getIsQuad() {
        return (Boolean)this.f_19804_.m_135370_(IS_QUAD);
    }

    public AnnihilationBeamEntity(EntityType<? extends AnnihilationBeamEntity> type, Level world) {
        super(type, world);
        this.RADIUS = ((Float)this.f_19804_.m_135370_(B_RADIUS)).floatValue();
        this.appear = new ControlledAnim(3);
        this.appearVisual = new ControlledAnim(3);
        this.disappear = new ControlledAnim(3);
        this.on = true;
        this.blockSide = null;
        this.NextSound = 0;
        this.f_19811_ = true;
        if (world.f_46443_) {
            this.attractorPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    public AnnihilationBeamEntity(EntityType<? extends AnnihilationBeamEntity> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration, float damage, float Hpdamage, int delay, boolean isQuad, float followSpeed, float additionalRotation, float turnBackAtDurationPrecentage, boolean rightTurnFirst, float r) {
        this(type, world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.m_6034_(x, y, z);
        this.setDamage(damage);
        this.setHpDamage(Hpdamage);
        this.calculateEndPos();
        this.setIsQuad(isQuad);
        this.setFollowSpeed(followSpeed);
        this.setDelay(delay);
        this.setAdditionalRotation(additionalRotation);
        this.setIsTurningRightFirst(rightTurnFirst);
        this.setTurnBackPrecentage(turnBackAtDurationPrecentage);
        this.setRadius(r);
        if (!world.f_46443_) {
            this.setCasterID(caster.m_19879_());
        }
    }

    public float turnBackMoment() {
        return (float)this.getDuration() * this.getTurnBackPrecentage();
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    private void updateWithCaster() {
        if (this.caster != null) {
            float f;
            float f2 = Mth.m_14089_((float)(this.caster.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.caster.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)this.caster.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            LivingEntity livingEntity = this.caster;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                f = 0.0f;
            } else {
                f = 1.0f;
            }
            float vec = f;
            float offset = 0.0f;
            if (!this.getIsQuad() && !(this.caster instanceof Player)) {
                this.setYaw((float)((double)(this.caster.f_20885_ + 90.0f) * Math.PI / 180.0));
                this.setPitch((float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0));
            }
            if (!this.getIsQuad()) {
                if (!(this.caster instanceof Player)) {
                    double d;
                    double d2 = this.caster.m_20185_() + (double)vec * vecX + (double)(f2 * offset);
                    LivingEntity livingEntity2 = this.caster;
                    if (livingEntity2 instanceof Player) {
                        Player player = (Player)livingEntity2;
                        d = player.m_20186_() + 1.0;
                    } else {
                        d = this.caster.m_20186_() + 2.0;
                    }
                    this.m_6034_(d2, d, this.caster.m_20189_() + (double)vec * vecZ + (double)(f1 * offset));
                }
            } else {
                this.m_6034_(this.caster.m_20185_(), this.caster.m_20186_() + 2.0, this.caster.m_20189_());
            }
        }
    }

    public void spawnExplosions(float damage, int bulletamount, double amount) {
        block5: {
            LivingEntity livingentity;
            block4: {
                LivingEntity livingEntity = this.caster;
                if (!(livingEntity instanceof Mob)) break block4;
                Mob caster1 = (Mob)livingEntity;
                livingentity = caster1.m_5448_();
                if (livingentity == null) break block5;
                double d3 = Mth.m_14107_((double)caster1.m_20186_());
                double d0 = Math.min(this.m_20186_(), this.m_20186_());
                double d1 = Math.max(this.m_20186_(), this.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(this.endPosZ - this.m_20189_()), (double)(this.endPosX - this.m_20185_()));
                int l = 0;
                while ((double)l < amount) {
                    double d2 = 4.0 * (double)(l + 1);
                    int j = 1 * l;
                    float delay = (float)this.getDuration() * 0.75f;
                    this.spawnEnergyExplosions(this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d3, d1, caster1.m_146908_(), (int)((float)this.getDuration() - delay), damage, bulletamount);
                    ++l;
                }
                break block5;
            }
            livingentity = this.caster;
            if (livingentity instanceof Player) {
                Player caster1 = (Player)livingentity;
                System.out.println("ROT: " + caster1.m_146909_());
                if (caster1.m_146909_() > -20.0f && caster1.m_146909_() < 10.0f) {
                    double d3 = Mth.m_14107_((double)caster1.m_20186_());
                    double d0 = Math.min(this.m_20186_(), this.m_20186_());
                    double d1 = Math.max(this.m_20186_(), this.m_20186_()) + 1.0;
                    float f = (float)Mth.m_14136_((double)(this.endPosZ - this.m_20189_()), (double)(this.endPosX - this.m_20185_()));
                    int l = 0;
                    while ((double)l < amount) {
                        double d2 = 4.0 * (double)(l + 1);
                        int j = 1 * l;
                        float delay = (float)this.getDuration() * 0.75f;
                        this.spawnEnergyExplosions(this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d3, d1, caster1.m_146908_(), (int)((float)this.getDuration() - delay), damage, bulletamount);
                        ++l;
                    }
                }
            }
        }
    }

    private void spawnEnergyExplosions(double x, double z, double minY, double maxY, float rotation, int delay, float damage, int bulletamount) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            this.m_9236_().m_7967_((Entity)new AnnihilationExplosionEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, this.caster, 20, damage, bulletamount));
        }
    }

    public void onAddedToWorld() {
        if (this.getIsQuad() && this.caster != null) {
            this.setYaw(this.caster.f_20883_ + this.getAdditionalRotation());
            this.m_146922_(this.caster.f_20883_ + this.getAdditionalRotation());
        }
        if (!this.getIsQuad()) {
            System.out.println("DistanceToVec3: " + MathUtils.distanceToVec(this.m_20182_(), this.endPos()));
            Vec3 collidePos = new Vec3(this.collidePosX, this.collidePosY, this.collidePosZ);
            this.spawnExplosions(8.0f, 2, MathUtils.distanceToVec(this.m_20182_(), this.endPos()) / (float)Math.PI);
        }
        super.onAddedToWorld();
    }

    public double getRadius() {
        return this.RADIUS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8119_() {
        super.m_8119_();
        if (this.getIsQuad()) {
            if ((float)this.f_19797_ >= this.turnBackMoment()) {
                newYawDeg = Mth.m_14177_((float)(this.getIsTurningRightFirst() ? this.getYaw() + this.getFollowSpeed() : this.getYaw() - this.getFollowSpeed()));
                this.setYaw(newYawDeg);
                this.m_146922_(newYawDeg);
                this.renderYaw = (float)Math.toRadians(newYawDeg);
            } else {
                newYawDeg = Mth.m_14177_((float)(this.getIsTurningRightFirst() ? this.getYaw() - this.getFollowSpeed() : this.getYaw() + this.getFollowSpeed()));
                this.setYaw(newYawDeg);
                this.m_146922_(newYawDeg);
                this.renderYaw = (float)Math.toRadians(newYawDeg);
            }
        }
        if (this.NextSound == 0 && this.f_19797_ >= 20) {
            this.NextSound = 10;
        }
        if (this.NextSound <= 0) {
            --this.NextSound;
        }
        if (this.f_19797_ >= this.getDuration()) {
            this.m_146870_();
        }
        if (this.caster != null) {
            this.updateWithCaster();
            this.calculateEndPos();
        }
        if (!this.on && this.appear.getTimer() == 0) {
            this.m_146870_();
        }
        if (this.on && this.f_19797_ > this.getDelay()) {
            this.appear.increaseTimer();
        } else {
            this.appear.decreaseTimer();
        }
        if (this.f_19797_ - this.getDelay() > this.getDuration()) {
            this.on = false;
        }
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.f_19797_ == 1 && this.m_9236_().f_46443_) {
            this.caster = (LivingEntity)this.m_9236_().m_6815_(this.getCasterID());
        }
        if (this.caster != null) {
            if (!(this.caster instanceof Player)) {
                if (!this.getIsQuad()) {
                    this.renderYaw = (float)(((double)this.caster.f_20885_ + 90.0) * Math.PI / 180.0);
                    this.renderPitch = (float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0);
                } else {
                    if (!this.getIsQuad()) {
                        this.renderYaw = (float)((double)this.m_146908_() * Math.PI / 180.0);
                    }
                    this.renderPitch = (float)((double)this.m_146909_() * Math.PI / 180.0);
                }
            } else if (this.f_19797_ == 1) {
                if (!this.getIsQuad()) {
                    this.renderYaw = (float)(((double)this.caster.f_20885_ + 90.0) * Math.PI / 180.0);
                    this.renderPitch = (float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0);
                } else {
                    if (!this.getIsQuad()) {
                        this.renderYaw = (float)((double)this.m_146908_() * Math.PI / 180.0);
                    }
                    this.renderPitch = (float)((double)this.m_146909_() * Math.PI / 180.0);
                }
            }
        }
        if (this.caster != null && !this.caster.m_6084_()) {
            this.m_146870_();
        }
        if (this.f_19797_ > this.getDelay()) {
            if (this.caster != null) {
                Mob caster1;
                LivingEntity livingEntity = this.caster;
                if (livingEntity instanceof Mob && (caster1 = (Mob)livingEntity).m_5448_() == null) {
                    // empty if block
                }
            } else {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.2f, 0, 2);
            }
            this.calculateEndPos();
            List<LivingEntity> hit = this.raytraceEntities((Level)this.m_9236_(), (Vec3)new Vec3((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ), (boolean)false, (boolean)true, (boolean)true).entities;
            if (this.blockSide != null) {
                this.spawnExplosionParticles(5);
                if (!this.m_9236_().f_46443_) {
                    for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.collidePosX - 2.5)), (int)Mth.m_14107_((double)(this.collidePosY - 2.5)), (int)Mth.m_14107_((double)(this.collidePosZ - 2.5)), (int)Mth.m_14107_((double)(this.collidePosX + 2.5)), (int)Mth.m_14107_((double)(this.collidePosY + 2.5)), (int)Mth.m_14107_((double)(this.collidePosZ + 2.5)))) {
                        BlockState blockState = this.m_9236_().m_8055_(pos);
                    }
                    if (this.getFire()) {
                        // empty if block
                    }
                }
            }
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : hit) {
                    boolean flag;
                    TamableAnimal animal;
                    if (this.caster == null || this.caster.m_7307_((Entity)target) || target == this.caster || target instanceof TamableAnimal && (animal = (TamableAnimal)target).m_269323_() == this.caster || !(flag = target.m_6469_(ModDamageTypes.causeAnnihilationDamage(this, this.caster), (float)((double)this.getDamage() + (double)target.m_21233_() * ((double)this.getHpDamage() * 0.01))))) continue;
                    TheObliteratorUtils.applyAnnihilationEffect(target, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                    if (this.caster instanceof Mob) {
                        // empty if block
                    }
                    target.m_20254_(2);
                }
            }
        }
        if (this.f_19797_ - 20 > this.getDuration() && this.getIsQuad()) {
            this.on = false;
            return;
        }
        this.on = true;
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 1.5f;
            float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
            float motionY = this.f_19796_.m_188501_() * 0.8f;
            float motionX = 1.5f * Mth.m_14089_((float)yaw);
            float motionZ = 1.5f * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.ANNIHILATION_EXPLOSION.get(), this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DURATION, (Object)0);
        this.f_19804_.m_135372_(CASTER, (Object)-1);
        this.f_19804_.m_135372_(HEAD, (Object)0);
        this.f_19804_.m_135372_(FIRE, (Object)false);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HPDAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(B_RADIUS, (Object)Float.valueOf(30.0f));
        this.f_19804_.m_135372_(RIGHT_TURN_FIRST, (Object)false);
        this.f_19804_.m_135372_(PRECENTAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ADDITIONAL_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FOLLOW_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_QUAD, (Object)false);
        this.f_19804_.m_135372_(DELAY, (Object)0);
    }

    public boolean getIsTurningRightFirst() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_TURN_FIRST);
    }

    public void setIsTurningRightFirst(boolean turn) {
        this.f_19804_.m_135381_(RIGHT_TURN_FIRST, (Object)turn);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getHpDamage() {
        return ((Float)this.f_19804_.m_135370_(HPDAMAGE)).floatValue();
    }

    public void setHpDamage(float damage) {
        this.f_19804_.m_135381_(HPDAMAGE, (Object)Float.valueOf(damage));
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yaw));
        if (this.caster instanceof Player) {
            this.renderYaw = (float)(((double)this.caster.f_20885_ + 90.0) * Math.PI / 180.0);
        }
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(pitch));
        if (this.caster instanceof Player) {
            this.renderPitch = (float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0);
        }
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DURATION, (Object)duration);
    }

    public int getHead() {
        return (Integer)this.f_19804_.m_135370_(HEAD);
    }

    public void setHead(int head) {
        this.f_19804_.m_135381_(HEAD, (Object)head);
    }

    public int getCasterID() {
        return (Integer)this.f_19804_.m_135370_(CASTER);
    }

    public void setCasterID(int id) {
        this.f_19804_.m_135381_(CASTER, (Object)id);
    }

    public boolean getFire() {
        return (Boolean)this.f_19804_.m_135370_(FIRE);
    }

    public void setFire(boolean fire2) {
        this.f_19804_.m_135381_(FIRE, (Object)fire2);
    }

    protected void m_7378_(CompoundTag nbt) {
        nbt.m_128405_("int", this.getDuration());
    }

    protected void m_7380_(CompoundTag nbt) {
        this.setDuration(nbt.m_128451_("int"));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void calculateEndPos() {
        float r;
        float f = r = this.caster instanceof Player ? ((Float)this.f_19804_.m_135370_(B_RADIUS)).floatValue() / 2.0f : ((Float)this.f_19804_.m_135370_(B_RADIUS)).floatValue();
        if (this.getIsQuad()) {
            double yawRad = Math.toRadians(this.getYaw());
            double pitchRad = Math.toRadians(this.getPitch());
            this.endPosX = this.m_20185_() + (double)r * Math.cos(yawRad) * Math.cos(pitchRad);
            this.endPosZ = this.m_20189_() + (double)r * Math.sin(yawRad) * Math.cos(pitchRad);
            this.endPosY = this.m_20186_() + (double)r * Math.sin(pitchRad);
        } else if (this.m_9236_().m_5776_()) {
            this.endPosX = this.m_20185_() + (double)r * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.m_20189_() + (double)r * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.m_20186_() + (double)r * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.m_20185_() + (double)r * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.m_20189_() + (double)r * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.m_20186_() + (double)r * Math.sin(this.getPitch());
        }
    }

    private void calculateFakeEndPos() {
        if (this.getIsQuad()) {
            float r = this.caster instanceof Player ? ((Float)this.f_19804_.m_135370_(B_RADIUS)).floatValue() / 2.0f : ((Float)this.f_19804_.m_135370_(B_RADIUS)).floatValue();
            double yawRad = Math.toRadians(this.getYaw());
            double pitchRad = Math.toRadians(this.getPitch());
            this.endPosX = this.m_20185_() + (double)r * Math.cos(yawRad) * Math.cos(pitchRad);
            this.endPosZ = this.m_20189_() + (double)r * Math.sin(yawRad) * Math.cos(pitchRad);
            this.endPosY = this.m_20186_() + (double)r * Math.sin(pitchRad);
        }
    }

    private Vec3 endPos() {
        return new Vec3(this.endPosX, this.endPosY, this.endPosZ);
    }

    public LaserbeamHitResult raytraceEntities(Level world, Vec3 from, Vec3 to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        LaserbeamHitResult result = new LaserbeamHitResult();
        result.setBlockHit((HitResult)world.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vec3 hitVec = result.blockHit.m_82450_();
            this.collidePosX = hitVec.f_82479_;
            this.collidePosY = hitVec.f_82480_;
            this.collidePosZ = hitVec.f_82481_;
            this.blockSide = result.blockHit.m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.m_6143_() + 0.5f;
            AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public void m_7334_(Entity entityIn) {
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    public static class LaserbeamHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

