/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import java.util.List;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.AnnihilationBombTrail;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Chorusling.TheWarpedOne.TheWarpedOneOld;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorUtils;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.SmallAnnihilationBombEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class AnnihilationBombEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AnnihilationBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> SILENT = SynchedEntityData.m_135353_(AnnihilationBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BULLETS_AMOUNT = SynchedEntityData.m_135353_(AnnihilationBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AnnihilationBombEntity(EntityType<AnnihilationBombEntity> type, Level world) {
        super(type, world);
    }

    public AnnihilationBombEntity(EntityType<AnnihilationBombEntity> type, Level world, LivingEntity thrower, float damage, int bulletsAmount, boolean silent) {
        super(type, thrower, world);
        this.m_5602_((Entity)thrower);
        this.setDamage(damage);
        this.setBulletsAmount(bulletsAmount);
        this.setSilent1(silent);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BULLETS_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(SILENT, (Object)false);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean isSilent1() {
        return (Boolean)this.f_19804_.m_135370_(SILENT);
    }

    public void setSilent1(boolean silent) {
        this.f_19804_.m_135381_(SILENT, (Object)silent);
    }

    public float getBulletAmount() {
        return ((Integer)this.f_19804_.m_135370_(BULLETS_AMOUNT)).intValue();
    }

    public void setBulletsAmount(int bulletsAmount) {
        this.f_19804_.m_135381_(BULLETS_AMOUNT, (Object)bulletsAmount);
    }

    protected void m_5790_(EntityHitResult result) {
        TamableAnimal animal;
        super.m_5790_(result);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity target = result.m_82443_();
        Entity owner = this.m_19749_();
        if (!(owner == null || target != owner || target instanceof TamableAnimal && (animal = (TamableAnimal)target).m_269323_() == owner)) {
            return;
        }
        if (target instanceof LivingEntity && owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            target.m_6469_(ModDamageTypes.causeAnnihilationDamage((Entity)livingOwner, livingOwner), this.getDamage());
            TheObliteratorUtils.applyAnnihilationEffect((LivingEntity)target, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
        }
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    public void AreaAttack(float range, float height, float arc, float damage) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.m_146908_() % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof TheWarpedOneOld || !(this.m_19749_() instanceof LivingEntity)) continue;
            boolean bl = entityHit.m_6469_(ModDamageTypes.causeAnnihilationDamage(this.m_19749_(), (LivingEntity)this.m_19749_()), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.StratlingDamageMultiplier.get()));
        }
    }

    public void m_6532_(HitResult result) {
        Level throwAngle;
        float speed;
        SmallAnnihilationBombEntity projectile;
        double v3;
        double vz;
        double vy;
        double vx;
        double sz;
        double sy;
        double sx;
        float throwAngle2;
        super.m_6532_(result);
        if (this.isSilent1()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.DIMENSIONAL_BOMB_EXPLODE.get(), this.m_5720_(), 0.3f, 1.0f, false);
        } else {
            this.m_5496_((SoundEvent)ModSounds.DIMENSIONAL_BOMB_EXPLODE.get(), 1.0f, 1.0f);
        }
        LivingEntity entity = (LivingEntity)this.m_19749_();
        float smallBulletAmount = this.getBulletAmount() * 0.5f;
        int i = 0;
        while ((float)i < smallBulletAmount) {
            if (entity != null) {
                throwAngle2 = (float)i * (float)Math.PI / (smallBulletAmount / 2.0f);
                sx = this.m_20185_() + (double)(Mth.m_14089_((float)throwAngle2) * 1.0f);
                sy = this.m_20186_() + (double)this.m_20206_() * 0.2;
                sz = this.m_20189_() + (double)(Mth.m_14031_((float)throwAngle2) * 1.0f);
                vx = Mth.m_14089_((float)throwAngle2);
                vy = 0.0f + entity.m_217043_().m_188501_() * 0.3f;
                vz = Mth.m_14031_((float)throwAngle2);
                v3 = Mth.m_14116_((float)((float)(vx * vx + vz * vz)));
                projectile = new SmallAnnihilationBombEntity((EntityType<SmallAnnihilationBombEntity>)((EntityType)ModEntities.SMALL_ANNIHILATION_BOMB_ENTITY.get()), entity.m_9236_(), entity, 8.0f);
                projectile.m_7678_(sx, sy, sz, (float)i * 11.25f, this.m_146909_());
                speed = 0.5f;
                projectile.m_6686_(vx, vy + v3 * 2.0, vz, speed, 1.0f);
                entity.m_9236_().m_7967_((Entity)projectile);
            }
            ++i;
        }
        i = 0;
        while ((float)i < this.getBulletAmount()) {
            if (entity != null) {
                throwAngle2 = (float)i * (float)Math.PI / (this.getBulletAmount() / 2.0f);
                sx = this.m_20185_() + (double)(Mth.m_14089_((float)throwAngle2) * 1.0f);
                sy = this.m_20186_() + (double)this.m_20206_() * 0.2;
                sz = this.m_20189_() + (double)(Mth.m_14031_((float)throwAngle2) * 1.0f);
                vx = Mth.m_14089_((float)throwAngle2);
                vy = 0.0f + entity.m_217043_().m_188501_() * 0.3f;
                vz = Mth.m_14031_((float)throwAngle2);
                v3 = Mth.m_14116_((float)((float)(vx * vx + vz * vz)));
                projectile = new SmallAnnihilationBombEntity((EntityType<SmallAnnihilationBombEntity>)((EntityType)ModEntities.SMALL_ANNIHILATION_BOMB_ENTITY.get()), entity.m_9236_(), (LivingEntity)this.m_19749_(), 8.0f);
                projectile.m_7678_(sx, sy, sz, (float)i * 11.25f, this.m_146909_());
                speed = 0.7f;
                projectile.m_6686_(vx, vy + v3 * (double)0.2f, vz, speed, 1.0f);
                entity.m_9236_().m_7967_((Entity)projectile);
            }
            ++i;
        }
        if (!this.m_9236_().f_46443_ && (throwAngle = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)throwAngle;
            double d0 = this.m_20185_();
            double d1 = this.m_20186_() + 2.0;
            double d2 = this.m_20189_();
            server.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ANNIHILATION_FLAME_STRIKE.get()), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.f_19797_ % 3 == 0) {
                int i = 0;
                while ((double)i < 0.1) {
                    if (this.m_9236_().f_46443_) {
                        double uniformScale = 0.5;
                        this.m_9236_().m_7106_((ParticleOptions)ModParticles.BIG_ANNIHILATION_FLAME.get(), this.m_20208_(uniformScale), this.m_20187_(), this.m_20262_(uniformScale), 0.0, 0.025, 0.0);
                    }
                    ++i;
                }
            }
            double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dy = this.m_20186_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            float ran = 0.4f;
            float r = 0.0f;
            float g = 0.7647059f + this.f_19796_.m_188501_() * ran;
            float b = 0.0f;
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 0.8f, this.m_19879_()), dx, dy, dz, 0.0, 0.0, 0.0);
            }
            double d0 = (double)this.f_19796_.m_188501_() + this.m_20184_().f_82479_;
            double d1 = (double)this.f_19796_.m_188501_() + this.m_20184_().f_82480_;
            double d = (double)this.f_19796_.m_188501_() + this.m_20184_().f_82481_;
        }
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.f_19797_ = 0;
        } else {
            super.m_7822_(id);
        }
    }

    protected float m_7139_() {
        return 0.03f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

