/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorUtils;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.INoRendererEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.SmallAnnihilationBombEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class AnnihilationExplosionEntity
extends INoRendererEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 20;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(AnnihilationExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AnnihilationExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(AnnihilationExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BULLETS_AMOUNT = SynchedEntityData.m_135353_(AnnihilationExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float activateProgress;
    public float prevactivateProgress;
    public AnimationState emergeAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(AnnihilationExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AnnihilationExplosionEntity(EntityType<? extends AnnihilationExplosionEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public void setLifeTicks(int lifeTicks) {
        this.lifeTicks = lifeTicks;
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public AnnihilationExplosionEntity(Level worldIn, double x, double y, double z, float yRot, int warmup, LivingEntity casterIn, int lifeTicks, float damage, int bulletamount) {
        this((EntityType<? extends AnnihilationExplosionEntity>)((EntityType)ModEntities.ENERGY_EXPLOSION.get()), worldIn);
        this.warmupDelayTicks = warmup;
        this.setCaster(casterIn);
        this.m_146922_(yRot * 57.295776f);
        this.setBulletsAmount(bulletamount);
        this.m_6034_(x, y, z);
        this.setLifeTicks(lifeTicks);
        this.setDamage(damage);
    }

    public float getBulletAmount() {
        return ((Integer)this.f_19804_.m_135370_(BULLETS_AMOUNT)).intValue();
    }

    public void setBulletsAmount(int bulletsAmount) {
        this.f_19804_.m_135381_(BULLETS_AMOUNT, (Object)bulletsAmount);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BULLETS_AMOUNT, (Object)0);
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 15) {
                    double d0 = this.m_20185_();
                    double d1 = this.m_20186_() + 2.0;
                    double d2 = this.m_20189_();
                    this.m_9236_().m_7107_((ParticleOptions)ModParticles.ANNIHILATION_EXPLOSION.get(), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                // empty if block
            }
            if (this.warmupDelayTicks == -8) {
                LivingEntity entity = this.getCaster();
                float smallBulletAmount = this.getBulletAmount();
                int i = 0;
                while ((float)i < smallBulletAmount) {
                    if (entity != null) {
                        float throwAngle = (float)i * (float)Math.PI / (this.getBulletAmount() / 2.0f);
                        double sx = this.m_20185_() + (double)(Mth.m_14089_((float)throwAngle) * 1.0f);
                        double sy = this.m_20186_() + (double)this.m_20206_() * 0.2;
                        double sz = this.m_20189_() + (double)(Mth.m_14031_((float)throwAngle) * 1.0f);
                        double vx = Mth.m_14089_((float)throwAngle);
                        double vy = 0.0f + entity.m_217043_().m_188501_() * 0.3f;
                        double vz = Mth.m_14031_((float)throwAngle);
                        double v3 = Mth.m_14116_((float)((float)(vx * vx + vz * vz)));
                        SmallAnnihilationBombEntity projectile = new SmallAnnihilationBombEntity((EntityType<SmallAnnihilationBombEntity>)((EntityType)ModEntities.SMALL_ANNIHILATION_BOMB_ENTITY.get()), entity.m_9236_(), entity, 6.0f);
                        projectile.setTurnRate(0.0f);
                        projectile.m_7678_(sx, sy, sz, (float)i * 11.25f, this.m_146909_());
                        float speed = 0.5f;
                        projectile.m_6686_(vx, vy + v3 * 2.0, vz, speed, 1.0f);
                        entity.m_9236_().m_7967_((Entity)projectile);
                    }
                    ++i;
                }
            }
            if (this.warmupDelayTicks > -8) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    private void damage(LivingEntity ImpactEntity) {
        LivingEntity livingentity = this.getCaster();
        if (ImpactEntity.m_6084_() && !ImpactEntity.m_20147_() && ImpactEntity != livingentity && this.f_19797_ % 1 == 0) {
            if (livingentity == null) {
                DamageSource damageSource;
                boolean hurt;
                TamableAnimal animal;
                if ((!(ImpactEntity instanceof TamableAnimal) || (animal = (TamableAnimal)ImpactEntity).m_269323_() != livingentity) && (hurt = ImpactEntity.m_6469_(damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ANNIHILATION), (Entity)livingentity), this.getDamage()))) {
                    TheObliteratorUtils.applyAnnihilationEffect(ImpactEntity, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                }
            } else {
                DamageSource damageSource;
                boolean hurt;
                TamableAnimal animal;
                if (livingentity.m_7307_((Entity)ImpactEntity)) {
                    return;
                }
                if ((!(ImpactEntity instanceof TamableAnimal) || (animal = (TamableAnimal)ImpactEntity).m_269323_() != livingentity) && (hurt = ImpactEntity.m_6469_(damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ANNIHILATION), (Entity)livingentity), this.getDamage()))) {
                    TheObliteratorUtils.applyAnnihilationEffect(ImpactEntity, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, this.m_5720_(), 0.3f, 1.25f, false);
            }
        } else if (id <= 0) {
            this.lifeTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "emerge") {
            return this.emergeAnimationState;
        }
        return new AnimationState();
    }

    public void setSleep(boolean sleep) {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 25, 0.0f, 1.0f, 0.0f, 1.0f, 14.0f, false, Circle.EnumRingBehavior.SHRINK), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }
}

