/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorUtils;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.INoRendererEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class AnnihilationFlameStrike
extends INoRendererEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 20;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(AnnihilationFlameStrike.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AnnihilationFlameStrike.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(AnnihilationFlameStrike.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float activateProgress;
    public float prevactivateProgress;
    public AnimationState emergeAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(AnnihilationFlameStrike.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AnnihilationFlameStrike(EntityType<? extends AnnihilationFlameStrike> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public void setLifeTicks(int lifeTicks) {
        this.lifeTicks = lifeTicks;
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public AnnihilationFlameStrike(Level worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn, int lifeTicks, float damage) {
        this((EntityType<? extends AnnihilationFlameStrike>)((EntityType)ModEntities.GREEN_FLAME_STRIKE.get()), worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.m_146922_(p_i47276_8_ * 57.295776f);
        this.m_6034_(x, y, z);
        this.setLifeTicks(lifeTicks);
        this.setDamage(damage);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void applyAnnihilationEffect(LivingEntity entity, MobEffect effect, int bonusLevel) {
        int duration = 200;
        MobEffectInstance effectInstance = entity.m_21124_(effect);
        if (entity.m_21023_(effect) && effectInstance != null) {
            int effectLevel = effectInstance.m_19564_();
            if (effectLevel < 5) {
                entity.m_7292_(new MobEffectInstance(effect, duration, effectLevel + bonusLevel));
            }
        } else if (!entity.m_21023_(effect) || effectInstance == null) {
            entity.m_7292_(new MobEffectInstance(effect, duration, 0));
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 19) {
                    double d0 = this.m_20185_();
                    double d1 = this.m_20186_() + 2.0;
                    double d2 = this.m_20189_();
                    this.m_9236_().m_7107_((ParticleOptions)ModParticles.ANNIHILATION_FLAME_STRIKE.get(), d0, d1, d2, 0.0, 0.0, 0.0);
                }
                if (this.lifeTicks == 15) {
                    // empty if block
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                // empty if block
            }
            if (this.warmupDelayTicks > -8) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    private void damage(LivingEntity ImpactEntity) {
        LivingEntity livingentity = this.getCaster();
        if (ImpactEntity.m_6084_() && !ImpactEntity.m_20147_() && ImpactEntity != livingentity && this.f_19797_ % 1 == 0) {
            if (livingentity == null) {
                float m = ImpactEntity.m_21233_() * 0.03f;
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ANNIHILATION), (Entity)livingentity);
                boolean hurt = ImpactEntity.m_6469_(damageSource, this.getDamage() + m);
                if (hurt) {
                    TheObliteratorUtils.applyAnnihilationEffect(ImpactEntity, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                    ImpactEntity.m_20254_(5);
                }
            } else {
                if (livingentity.m_7307_((Entity)ImpactEntity)) {
                    return;
                }
                float m = ImpactEntity.m_21233_() * 0.03f;
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ANNIHILATION), (Entity)livingentity);
                boolean hurt = ImpactEntity.m_6469_(damageSource, this.getDamage() + m);
                if (hurt) {
                    TheObliteratorUtils.applyAnnihilationEffect(ImpactEntity, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                    ImpactEntity.m_20254_(5);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, this.m_5720_(), 0.3f, 1.25f, false);
            }
        } else if (id <= 0) {
            this.lifeTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "emerge") {
            return this.emergeAnimationState;
        }
        return new AnimationState();
    }

    public void setSleep(boolean sleep) {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 15, 0.0f, 1.0f, 0.0f, 1.0f, 14.0f, false, Circle.EnumRingBehavior.SHRINK), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }
}

