/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.AnnihilationBombTrail;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorUtils;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.INoRendererEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationGroundNukeStrikeEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.client.ControlledAnim;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class AnnihilationPortalEntity
extends INoRendererEntity {
    public int warmupDelayTicks = 10;
    private boolean sentSpikeEvent;
    private int lifeTicks = 100;
    public int disappearTicks = 20;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> TYPE_A = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> TYPE_B = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DANGEROUS = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_BIG = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float activateProgress;
    public float prevactivateProgress;
    public int warmupValue;
    public ControlledAnim anim = new ControlledAnim(10);
    public int lifeTicks1 = 0;
    public AnimationState emergeAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(AnnihilationPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public boolean is75pLife() {
        return (double)this.lifeTicks >= (double)this.lifeTicks * 0.75;
    }

    public AnnihilationPortalEntity(EntityType<? extends AnnihilationPortalEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public void setLifeTicks(int lifeTicks) {
        this.lifeTicks = lifeTicks;
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public AnnihilationPortalEntity(Level worldIn, double x, double y, double z, float p_i47276_8_, int warmup, LivingEntity casterIn, int lifeTicks, float damage, boolean dangerous, float scale) {
        this((EntityType<? extends AnnihilationPortalEntity>)((EntityType)ModEntities.ANNIHILATION_PORTAL.get()), worldIn);
        this.warmupDelayTicks = warmup;
        this.setCaster(casterIn);
        this.m_146922_(p_i47276_8_ * 57.295776f);
        this.m_6034_(x, y, z);
        this.setLifeTicks(lifeTicks);
        this.setDamage(damage);
        this.setDangerous(dangerous);
        this.setScale(scale);
        this.setWarmupValue(warmup);
    }

    public boolean isA() {
        return (Boolean)this.f_19804_.m_135370_(TYPE_A);
    }

    public boolean isB() {
        return (Boolean)this.f_19804_.m_135370_(TYPE_B);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE_B, (Object)false);
        this.f_19804_.m_135372_(TYPE_A, (Object)false);
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(IS_DANGEROUS, (Object)false);
        this.f_19804_.m_135372_(IS_BIG, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        this.m_6210_();
        super.m_7350_(p_21104_);
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setDangerous(boolean isDangerous) {
        this.f_19804_.m_135381_(IS_DANGEROUS, (Object)isDangerous);
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(IS_DANGEROUS);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(IS_DANGEROUS, (Object)compound.m_128471_("danger"));
        this.f_19804_.m_135381_(IS_BIG, (Object)compound.m_128471_("big"));
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("danger", ((Boolean)this.f_19804_.m_135370_(IS_DANGEROUS)).booleanValue());
        compound.m_128379_("big", ((Boolean)this.f_19804_.m_135370_(IS_BIG)).booleanValue());
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)(this.isBig() ? 5.0f : 3.0f), (float)(this.isDangerous() ? 4.0f : 0.5f));
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
    }

    public void m_6210_() {
        super.m_6210_();
    }

    public float matrixScale() {
        return this.getScale();
    }

    public int warmupValue() {
        return this.warmupValue;
    }

    public void setWarmupValue(int warmupValue) {
        this.warmupValue = warmupValue;
    }

    public boolean isBig() {
        return this.getScale() == 6.0f || this.getScale() == 4.0f;
    }

    public void setIsBig(boolean isBig) {
        this.f_19804_.m_135381_(IS_BIG, (Object)isBig);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTicks1;
        if (this.matrixScale() == 4.0f) {
            int d;
            int i;
            int warningTick = 43;
            int attackTick = 46;
            if (this.lifeTicks1 == attackTick) {
                this.m_5496_((SoundEvent)ModSounds.OMINOUS_EXPLOSION.get(), 1.0f, 1.0f);
            }
            for (i = warningTick; i <= warningTick + 6; i += 2) {
                if (this.lifeTicks1 != i) continue;
                d = i - (warningTick - 2);
                this.flameRadagonShockwave(2.0f, d, 1.0f, 2, 0.0f, 0.0f, 17.0f, true);
            }
            for (i = attackTick; i <= attackTick + 6; i += 2) {
                if (this.lifeTicks1 != i) continue;
                d = i - (attackTick - 2);
                this.flameRadagonShockwave(2.0f, d, 1.0f, 2, 0.0f, 0.0f, 7.0f, false);
            }
        }
        double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
        double dy = this.m_20186_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
        double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
        float ran = 0.4f;
        float r = 0.0f;
        float g = 0.7647059f + this.f_19796_.m_188501_() * ran;
        float b = 0.0f;
        float scale = (Mth.m_14031_((float)((float)this.f_19797_ * 0.2f)) * 0.5f + 0.5f) * this.matrixScale();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, scale, 0.2f, this.m_19879_()), dx, dy, dz, (double)scale, (double)scale, (double)scale);
        }
        this.m_6210_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 15) {
                    // empty if block
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            // empty if block
        }
        if (this.warmupDelayTicks < -12 && this.isDangerous()) {
            for (Level entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(this.isBig() ? 2.5 : 1.5))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingentity = (LivingEntity)entity;
                if (entity == this.getCaster() || entity instanceof Player && ((Player)entity).m_150110_().f_35934_ || livingentity == this.getCaster()) continue;
                Vec3 diff = livingentity.m_20182_().m_82546_(this.m_20182_().m_82520_(0.0, 0.0, 0.0));
                diff = diff.m_82541_().m_82490_(0.03);
                livingentity.m_20256_(livingentity.m_20184_().m_82546_(diff));
                EntityUtil.applyPlayerDeltaMovement(livingentity);
            }
        }
        if (this.warmupDelayTicks <= -16) {
            Object level;
            if (this.isDangerous()) {
                Level dx12;
                Level entity;
                if (this.f_19797_ % 16 == 0 && this.isBig() && (entity = this.m_9236_()) instanceof ServerLevel) {
                    level = (ServerLevel)entity;
                    level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ANNIHILATION_NUKE.get()), this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.f_19797_ % 5 == 0 && this.isBig() && (entity = this.m_9236_()) instanceof ServerLevel) {
                    level = (ServerLevel)entity;
                    double dx12 = this.m_20185_() + (double)((this.isBig() ? 6.0f : 4.5f) * (this.f_19796_.m_188501_() - (this.isBig() ? 1.0f : 0.5f)));
                    double dy1 = this.m_20186_() + (double)((this.isBig() ? 6.0f : 4.5f) * (this.f_19796_.m_188501_() - (this.isBig() ? 1.0f : 0.5f)));
                    double dz1 = this.m_20189_() + (double)((this.isBig() ? 6.0f : 4.5f) * (this.f_19796_.m_188501_() - (this.isBig() ? 1.0f : 0.5f)));
                    level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ANNIHILATION_NUKE.get()), dx12, this.m_20186_() + 4.0, dz1, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.f_19797_ % 8 == 0 && (dx12 = this.m_9236_()) instanceof ServerLevel) {
                    level = (ServerLevel)dx12;
                    if (!this.isBig()) {
                        level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ANNIHILATION_NUKE.get()), this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                for (LivingEntity entity2 : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
                    this.damage(entity2);
                }
            }
            if (this.warmupDelayTicks == -8) {
                // empty if block
            }
            if (this.warmupDelayTicks > -8) {
                this.anim.increaseTimer();
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                Object object;
                this.m_146870_();
                LivingEntity livingEntity = this.caster;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (this.getScale() == 4.0f) {
                        int n = Mth.m_14107_((double)this.m_20186_());
                    }
                }
                if ((object = this.m_9236_()) instanceof ServerLevel) {
                    level = (ServerLevel)object;
                    for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
                        this.damage(entity);
                    }
                    level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.GROUND_ANNIHILATION_NUKE.get()), this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public RandomSource getRandom() {
        return this.f_19796_;
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    /*
     * Unable to fully structure code
     */
    private void damage(LivingEntity ImpactEntity) {
        block4: {
            livingentity = this.getCaster();
            if (!ImpactEntity.m_6084_() || ImpactEntity.m_20147_() || ImpactEntity == livingentity || this.f_19797_ % 5 != 0 || livingentity == null) break block4;
            if (livingentity.m_7307_((Entity)ImpactEntity) || ImpactEntity instanceof TamableAnimal && (animal = (TamableAnimal)ImpactEntity).m_269323_() == this.getCaster()) {
                return;
            }
            if (this.matrixScale() == 2.0f) ** GOTO lbl8
            if (this.matrixScale() == 4.0f && (var5_5 = this.getCaster()) instanceof Player) {
                var4_6 = (Player)var5_5;
lbl8:
                // 2 sources

                v0 = 0.0f;
            } else {
                v0 = MathUtils.entityBasedHpDamage(ImpactEntity, ((Integer)ModConfig.MOB_CONFIG.TheObliteratorPortalHPDamage.get()).intValue());
            }
            m = v0;
            hurt = ImpactEntity.m_6469_(ModDamageTypes.causeAnnihilationDamage((Entity)livingentity, livingentity), this.getDamage() + m);
            if (this.warmupDelayTicks == -16 && hurt) {
                TheObliteratorUtils.applyAnnihilationEffect(ImpactEntity, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                livingentity.m_20334_(0.0, 0.5, 0.0);
                EntityUtil.applyPlayerDeltaMovement(livingentity);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id <= 0) {
            this.f_19797_ = 0;
            this.lifeTicks = 0;
        } else if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                // empty if block
            }
        } else {
            super.m_7822_(id);
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "emerge") {
            return this.emergeAnimationState;
        }
        return new AnimationState();
    }

    public void setSleep(boolean sleep) {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    private void spawnFlames(double x, double z, double minY, double maxY, float rotation, int delay, float damage) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            this.m_9236_().m_7967_((Entity)new AnnihilationGroundNukeStrikeEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, this.caster, 20, damage));
        }
    }

    public void doPortalEffect(double multiplier, float size, int amountOfPortals, int warmup, float scale, int life, float damage) {
        for (int k = 0; k < amountOfPortals; ++k) {
            float f3 = (float)k * (float)Math.PI * size / (float)amountOfPortals + (float)Math.PI * size / 10.0f;
            int standingOnY = Mth.m_14107_((double)this.m_20186_());
            this.spawnFlames(this.m_20185_() + (double)Mth.m_14089_((float)f3) * multiplier, this.m_20189_() + (double)Mth.m_14031_((float)f3) * multiplier, this.m_20186_() - 5.0, this.m_20186_() + 5.0, life, warmup, damage);
        }
    }

    private void flameRadagonShockwave(float spreadarc, int distance, float vec, int delay, float pos, float offset, float damage, boolean warningParticle) {
        float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        double theta1 = (double)this.m_146908_() * (Math.PI / 180);
        double vecX = Math.cos(theta1 += 1.5707963267948966);
        double vecZ = Math.sin(theta1);
        int floor = Mth.m_14107_((double)this.m_20186_());
        double x = this.m_20185_() + (double)pos * vecX + (double)(f * offset);
        double z = this.m_20189_() + (double)pos * vecZ + (double)(f1 * offset);
        double perpFacing = (double)this.m_146908_() * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread * (double)0.35f));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = x + vx * (double)distance + (double)vec * Math.cos((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0);
            double pz = z + vz * (double)distance + (double)vec * Math.sin((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0);
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            this.spawnFlames2((double)hitX + 0.5, (double)hitZ + 0.5, this.m_20186_() - 5.0, this.m_20186_() + 3.0, (float)theta, delay, damage, warningParticle, (ParticleOptions)ModParticles.GROUND_ANNIHILATION_NUKE.get());
        }
    }

    private void spawnFlames2(double x, double z, double minY, double maxY, float rotation, int delay, float damage, boolean particle, ParticleOptions particleOptions) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            if (!particle) {
                this.m_9236_().m_7967_((Entity)new AnnihilationGroundNukeStrikeEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, this.getCaster(), 20, damage));
            } else if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(0.0f, 1.5707964f, 30, 0.0f, 1.0f, 0.0f, 1.0f, 30.0f, false, Circle.EnumRingBehavior.SHRINK), x, (double)blockpos.m_123342_() + d0, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

