/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import net.miauczel.legendary_monsters.Particle.custom.LaserBulletTrail;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AbstractFlyingProjectile;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class LaserBulletEntity
extends AbstractFlyingProjectile {
    public double xPower;
    public double yPower;
    public double zPower;

    public LaserBulletEntity(EntityType<? extends LaserBulletEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public LaserBulletEntity(EntityType<? extends LaserBulletEntity> pEntityType, double pX, double pY, double pZ, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel) {
        this(pEntityType, pLevel);
        this.m_7678_(pX, pY, pZ, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(pOffsetX * pOffsetX + pOffsetY * pOffsetY + pOffsetZ * pOffsetZ);
        if (d0 != 0.0) {
            this.xPower = pOffsetX / d0 * 0.1;
            this.yPower = pOffsetY / d0 * 0.1;
            this.zPower = pOffsetZ / d0 * 0.1;
        }
    }

    public LaserBulletEntity(EntityType<? extends LaserBulletEntity> pEntityType, LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20186_(), pShooter.m_20189_(), pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.m_5602_((Entity)pShooter);
        this.m_19915_(pShooter.m_146908_(), pShooter.m_146909_());
    }

    @Override
    protected void m_8097_() {
    }

    @Override
    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    @Override
    public void m_8119_() {
        double dx = this.m_20185_();
        double dy = this.m_20186_();
        double dz = this.m_20189_();
        float ran = 0.4f;
        float r = 0.0f;
        float g = 0.7647059f + this.f_19796_.m_188501_() * ran;
        float b = 0.0f;
        this.m_9236_().m_7106_((ParticleOptions)new LaserBulletTrail.OrbData(r, g, b, 0.1f, 0.3f, this.m_19879_()), dx, dy, dz, 0.0, 0.0, 0.0);
        Entity entity = this.m_19749_();
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            HitResult hitresult;
            super.m_8119_();
            if (this.shouldBurn()) {
                this.m_20254_(1);
            }
            if ((hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            float f = this.getInertia();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d0 - vec3.f_82479_ * 0.25, d1 - vec3.f_82480_ * 0.25, d2 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                f = 0.8f;
            }
            this.m_20256_(vec3.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)f));
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_146870_();
        }
    }

    @Override
    protected boolean m_5603_(Entity p_36842_) {
        return super.m_5603_(p_36842_) && !p_36842_.f_19794_;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123762_;
    }

    @Override
    protected float getInertia() {
        return 0.6f;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        ListTag listtag;
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("power", 9) && (listtag = pCompound.m_128437_("power", 6)).size() == 3) {
            this.xPower = listtag.m_128772_(0);
            this.yPower = listtag.m_128772_(1);
            this.zPower = listtag.m_128772_(2);
        }
    }

    @Override
    public boolean m_6087_() {
        return true;
    }

    @Override
    public float m_6143_() {
        return 1.0f;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        this.m_5834_();
        Entity entity = pSource.m_7639_();
        if (entity != null) {
            if (!this.m_9236_().f_46443_) {
                Vec3 vec3 = entity.m_20154_();
                this.m_20256_(vec3);
                this.xPower = vec3.f_82479_ * 0.1;
                this.yPower = vec3.f_82480_ * 0.1;
                this.zPower = vec3.f_82481_ * 0.1;
                this.m_5602_(entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public float m_213856_() {
        return 1.0f;
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    @Override
    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        double d0 = pPacket.m_131503_();
        double d1 = pPacket.m_131504_();
        double d2 = pPacket.m_131505_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.xPower = d0 / d3 * 0.1;
            this.yPower = d1 / d3 * 0.1;
            this.zPower = d2 / d3 * 0.1;
        }
    }
}

