/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.AnnihilationBombTrail;
import net.miauczel.legendary_monsters.Particle.custom.LightningParticle;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorUtils;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.INoRendererEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationExplosionEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlasmaOrbEntity
extends INoRendererEntity {
    public double xPower;
    public double yPower;
    public double zPower;
    private LivingEntity caster;
    private UUID casterUuid;
    private boolean leftOwner;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(PlasmaOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> TRANSPARENCY = SynchedEntityData.m_135353_(PlasmaOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TURN_LEFT = SynchedEntityData.m_135353_(PlasmaOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> TURN_STRENGTH = SynchedEntityData.m_135353_(PlasmaOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int maxLife = 20;
    public int lifetick = 0;
    public AnimationState idleAnimationState = new AnimationState();
    boolean hasHurt = false;
    public boolean onFire = false;

    public PlasmaOrbEntity(EntityType<? extends PlasmaOrbEntity> type, Level level) {
        super(type, level);
    }

    public PlasmaOrbEntity(EntityType<? extends PlasmaOrbEntity> type, double getX, double gety, double getz, double p_36821_, double p_36822_, double p_36823_, Level level, float Yrot) {
        this(type, level);
        this.m_20343_(getX, gety, getz);
        double d0 = Math.sqrt(p_36821_ * p_36821_ + p_36822_ * p_36822_ + p_36823_ * p_36823_);
        if (d0 != 0.0) {
            this.xPower = p_36821_ / d0 * 0.1;
            this.yPower = p_36822_ / d0 * 0.1;
            this.zPower = p_36823_ / d0 * 0.1;
        }
    }

    public PlasmaOrbEntity(LivingEntity p_36827_, double p_36828_, double p_36829_, double p_36830_, Level p_36831_, float damage, float Yrot, float life) {
        this((EntityType<? extends PlasmaOrbEntity>)((EntityType)ModEntities.ENERGY_DISC.get()), p_36827_.m_20185_(), p_36827_.m_20186_(), p_36827_.m_20189_(), p_36828_, p_36829_, p_36830_, p_36831_, Yrot);
        this.setOwner(p_36827_);
        this.setDamage(damage);
        this.m_146922_(Yrot);
        this.maxLife = (int)life;
    }

    public PlasmaOrbEntity(EntityType<? extends PlasmaOrbEntity> type, LivingEntity p_36827_, double getX, double gety, double getz, double p_36821_, double p_36822_, double p_36823_, float damage, Level level) {
        this(type, level);
        this.m_7678_(getX, gety, getz, this.m_146908_(), this.m_146909_());
        this.setOwner(p_36827_);
        this.setDamage(damage);
        this.m_20090_();
        double d0 = Math.sqrt(p_36821_ * p_36821_ + p_36822_ * p_36822_ + p_36823_ * p_36823_);
        if (d0 != 0.0) {
            this.xPower = p_36821_ / d0 * 0.5;
            this.yPower = p_36822_ / d0 * 0.5;
            this.zPower = p_36823_ / d0 * 0.5;
        }
    }

    public void applyAnnihilationEffect(LivingEntity entity, MobEffect effect, int bonusLevel) {
        int duration = 200;
        MobEffectInstance effectInstance = entity.m_21124_(effect);
        if (entity.m_21023_(effect) && effectInstance != null) {
            int effectLevel = effectInstance.m_19564_();
            if (effectLevel < 5) {
                entity.m_7292_(new MobEffectInstance(effect, duration, effectLevel + bonusLevel));
            }
        } else if (!entity.m_21023_(effect) || effectInstance == null) {
            entity.m_7292_(new MobEffectInstance(effect, duration, 0));
        }
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TRANSPARENCY, (Object)0);
        this.f_19804_.m_135372_(TURN_LEFT, (Object)true);
        this.f_19804_.m_135372_(TURN_STRENGTH, (Object)Float.valueOf(4.5f));
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid);
            if (entity instanceof LivingEntity) {
                this.caster = (LivingEntity)entity;
            } else {
                this.casterUuid = null;
            }
        }
        return this.caster;
    }

    public AnimationState getAnimationState(String input) {
        if (input == "idle") {
            return this.idleAnimationState;
        }
        return new AnimationState();
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getTransparency() {
        return (Integer)this.f_19804_.m_135370_(TRANSPARENCY);
    }

    public void setTransparency(int trans) {
        this.f_19804_.m_135381_(TRANSPARENCY, (Object)trans);
    }

    public boolean m_6783_(double p_36837_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_36837_ < (d0 *= 64.0) * d0;
    }

    private void damage(LivingEntity ImpactEntity) {
        LivingEntity livingentity = this.getOwner();
        if (ImpactEntity.m_6084_() && !ImpactEntity.m_20147_() && ImpactEntity != livingentity && this.f_19797_ % 5 == 0) {
            if (livingentity == null) {
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ANNIHILATION), (Entity)livingentity);
                float m = ImpactEntity.m_21233_() * 0.03f;
                boolean flag = ImpactEntity.m_6469_(damageSource, this.getDamage() + m);
                if (flag) {
                    TheObliteratorUtils.applyAnnihilationEffect(ImpactEntity, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                }
            } else {
                if (livingentity.m_7307_((Entity)ImpactEntity)) {
                    return;
                }
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ANNIHILATION), (Entity)livingentity);
                float m = ImpactEntity.m_21233_() * 0.03f;
                boolean flag = ImpactEntity.m_6469_(damageSource, this.getDamage() + m);
                if (flag) {
                    TheObliteratorUtils.applyAnnihilationEffect(ImpactEntity, (MobEffect)ModEffects.ANNIHILATION.get(), 1, false);
                }
            }
        }
    }

    public void setTurnLeft(boolean left) {
        this.f_19804_.m_135381_(TURN_LEFT, (Object)left);
    }

    public boolean isTurnLeft() {
        return (Boolean)this.f_19804_.m_135370_(TURN_LEFT);
    }

    public void setTurnStrength(float strength) {
        this.f_19804_.m_135381_(TURN_STRENGTH, (Object)Float.valueOf(strength));
    }

    public float getTurnStrength() {
        return ((Float)this.f_19804_.m_135370_(TURN_STRENGTH)).floatValue();
    }

    public void m_8119_() {
        LivingEntity owner;
        HitResult hit;
        if (this.f_19797_ % 4 == 0) {
            int i = 0;
            while ((double)i < 0.1) {
                if (this.m_9236_().f_46443_) {
                    double uniformScale = 0.5;
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.BIG_ANNIHILATION_FLAME.get(), this.m_20208_(uniformScale), this.m_20187_(), this.m_20262_(uniformScale), 0.0, 0.025, 0.0);
                }
                ++i;
            }
        }
        if (this.m_9236_().f_46443_) {
            double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dy = this.m_20186_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            float ran = 0.4f;
            float r = 0.0f;
            float g = 0.7647059f + this.f_19796_.m_188501_() * ran;
            float b = 0.0f;
            this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.5f, 0.8f, this.m_19879_()), dx, dy, dz, 0.0, 0.0, 0.0);
            double d0 = (double)(this.f_19796_.m_188501_() - 0.5f) + this.m_20184_().f_82479_;
            double d1 = (double)(this.f_19796_.m_188501_() - 0.5f) + this.m_20184_().f_82480_;
            double d2 = (double)(this.f_19796_.m_188501_() - 0.5f) + this.m_20184_().f_82481_;
            double dist = 1.0f + this.f_19796_.m_188501_() * 0.2f;
            double d3 = d0 * dist;
            double d4 = d1 * dist;
            double d5 = d2 * dist;
            this.m_9236_().m_7106_((ParticleOptions)new LightningParticle.OrbData(25, 255, 0), this.m_20185_() + d0, this.m_20186_() + 1.0, this.m_20189_() + d2, d3, d4, d5);
            this.m_9236_().m_7106_((ParticleOptions)new LightningParticle.OrbData(255, 255, 255), this.m_20185_() + d0, this.m_20186_() + 1.0, this.m_20189_() + d2, d3, d4, d5);
        }
        super.m_8119_();
        if (this.f_19797_ % 2 == 0) {
            // empty if block
        }
        for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
            if (this.lifetick != this.maxLife - 2 || !this.m_9236_().f_46443_) continue;
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.DIMENSIONAL_EXPLOSION.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.lifetick >= this.maxLife && !this.m_9236_().f_46443_) {
            Level livingentity;
            Object dx;
            if (this.caster != null) {
                dx = new AnnihilationExplosionEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0, this.caster, 20, 7.0f, 2);
            }
            if ((livingentity = this.m_9236_()) instanceof ServerLevel) {
                dx = (ServerLevel)livingentity;
            }
            this.m_146870_();
        }
        if (!this.m_9236_().f_46443_) {
            ++this.lifetick;
            this.setTransparency(this.lifetick);
            if (this.lifetick >= this.maxLife) {
                LivingEntity livingentity = this.getOwner();
                if (livingentity instanceof Mob) {
                    Mob mob = (Mob)livingentity;
                    if (this.getOwner() == null || mob.m_5448_() != null) {
                        // empty if block
                    }
                }
                return;
            }
        } else {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        }
        if (this.lifetick == this.maxLife - 3) {
            for (Entity passenger : this.m_20197_()) {
                passenger.m_8127_();
            }
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if ((hit = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity)).m_6662_() != HitResult.Type.MISS) {
            this.onHit(hit);
        }
        BlockPos posHere = this.m_20183_().m_175288_((int)this.m_20186_());
        BlockPos posBelow = this.m_20183_().m_7495_();
        BlockState stateHere = this.m_9236_().m_8055_(posHere);
        BlockState stateBelow = this.m_9236_().m_8055_(posBelow);
        if (stateHere.m_60734_() instanceof FireBlock || stateBelow.m_60734_() instanceof FireBlock) {
            this.onFire = true;
        }
        if ((owner = this.getOwner()) != null && !owner.m_6084_()) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)10);
                this.m_146870_();
            }
            return;
        }
        float turnStrength = this.getTurnStrength();
        float deltaYaw = this.isTurnLeft() ? -turnStrength : turnStrength;
        float newYaw = this.m_146908_() + deltaYaw;
        this.m_146922_(newYaw);
        double rad = Math.toRadians(deltaYaw);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        Vec3 oldVel = this.m_20184_();
        Vec3 drifted = new Vec3(oldVel.f_82479_ * cos - oldVel.f_82481_ * sin, oldVel.f_82480_, oldVel.f_82479_ * sin + oldVel.f_82481_ * cos);
        double thrustMag = Math.sqrt(this.xPower * this.xPower + this.zPower * this.zPower);
        double yawRad = Math.toRadians(newYaw);
        Vec3 forward = new Vec3(-Math.sin(yawRad) * thrustMag, 0.0, Math.cos(yawRad) * thrustMag);
        Vec3 newVel = drifted.m_82490_((double)this.getInertia()).m_82549_(forward);
        this.m_20256_(newVel);
        this.m_6478_(MoverType.SELF, newVel);
    }

    protected void onHitEntity(EntityHitResult p_37626_) {
        Entity entity2 = p_37626_.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entity2;
            boolean b = this.getOwner() == null;
            LivingEntity entity1 = this.getOwner();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = entity1;
                float m = entity.m_21233_() * 0.03f;
                this.damage(entity);
                this.m_20334_(0.0, 0.0, 0.0);
                this.m_19970_(livingentity, (Entity)entity);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
    }

    protected void onHit(HitResult p_37260_) {
        HitResult.Type hitresult$type = p_37260_.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)p_37260_);
            this.hasHurt = true;
            this.m_9236_().m_214171_(GameEvent.f_157777_, p_37260_.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)p_37260_;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
    }

    protected boolean canHitEntity(Entity p_36842_) {
        return this.canHit(p_36842_) && !p_36842_.f_19794_;
    }

    protected boolean canHit(Entity p_37250_) {
        if (!p_37250_.m_271807_()) {
            return false;
        }
        LivingEntity entity = this.getOwner();
        return entity == null || this.leftOwner;
    }

    protected float getInertia() {
        return 0.9f;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        ListTag listtag;
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
        if (compound.m_128425_("power", 9) && (listtag = compound.m_128437_("power", 6)).size() == 3) {
            this.xPower = listtag.m_128772_(0);
            this.yPower = listtag.m_128772_(1);
            this.zPower = listtag.m_128772_(2);
        }
        this.leftOwner = compound.m_128471_("LeftOwner");
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
        if (this.leftOwner) {
            compound.m_128379_("LeftOwner", true);
        }
        compound.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    private boolean checkLeftOwner() {
        LivingEntity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_234613_0_ -> !p_234613_0_.m_5833_() && p_234613_0_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_6087_() {
        return false;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean inWater() {
        return false;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        int i = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, new Vec3(this.xPower, 0.0, this.zPower), 0.0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_150128_) {
        super.m_141965_(p_150128_);
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.f_19797_ = 0;
        } else {
            super.m_7822_(id);
        }
    }
}

