/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ThrownEntity;

import java.util.List;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.ShulkerTower.Shulker_MimicEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AbstractFlyingProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LinearEntityThrownEntity
extends AbstractFlyingProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(LinearEntityThrownEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    float interia = 1.0f;

    public LinearEntityThrownEntity(EntityType<? extends LinearEntityThrownEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public LinearEntityThrownEntity(Level pLevel, LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, float damage, float interia, LivingEntity passenger) {
        super(null, pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.setDamage(damage);
        this.setInteria(interia);
        if (passenger != null) {
            passenger.m_7998_((Entity)this, true);
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    protected float getInertia() {
        return this.interia;
    }

    public void setInteria(float interia1) {
        this.interia = interia1;
    }

    protected float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    public boolean m_6060_() {
        return false;
    }

    private void AreaAttack(float range, float height, float arc, float damage) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            Entity entity;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.m_146908_() % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Shulker_MimicEntity || this.m_19749_() == null || !((entity = this.m_19749_()) instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            float m = entityHit.m_21233_() * 0.01f;
            boolean bl = entityHit.m_6469_(ModDamageTypes.causeGravityDamage((Entity)livingEntity, livingEntity), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.ShulkerMimicDamageMutliplier.get() + (double)m));
        }
    }

    @Override
    public void m_8119_() {
        Entity entity;
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_(this.getTrailParticle(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ % 3 == 0) {
            float yaw = (float)Math.toRadians(-this.m_146908_() + 180.0f);
            float pitch = (float)Math.toRadians(-this.m_20185_() + 180.0);
            double theta = (double)this.m_146908_() * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            Vec3 vec3 = this.m_20184_();
            double spawnX = this.m_20185_() + vec3.f_82479_ + vecX * 1.5;
            double spawnZ = this.m_20189_() + vec3.f_82481_ + vecZ * 1.5;
            this.m_9236_().m_7106_((ParticleOptions)new Circle.RingData(yaw, pitch, 30, 1.0f, 1.0f, 1.0f, 1.0f, 40.0f, false, Circle.EnumRingBehavior.GROW_THEN_SHRINK), spawnX, this.m_20186_() + 1.0, spawnZ, 0.0, 0.0, 0.0);
        }
        if (this.m_20160_() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            player.m_20260_(false);
        }
        super.m_8119_();
    }

    public float m_7077_(Explosion pExplosion, BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, float pExplosionPower) {
        return pExplosionPower;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123796_;
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (pResult.m_82443_() == this.m_146895_()) {
            return;
        }
        super.m_5790_(pResult);
        if (!this.m_9236_().f_46443_) {
            Entity entity = pResult.m_82443_();
            Entity entity1 = this.m_19749_();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                boolean flag = entity.m_6469_(this.m_269291_().m_269333_(livingentity), 8.0f);
                if (flag && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        if (pResult instanceof EntityHitResult) {
            return;
        }
        super.m_6532_(pResult);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }
}

