/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.PhantomDaggerTrail;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AbstractFlyingProjectile;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownPhantomDagger
extends AbstractFlyingProjectile {
    public int clientSideReturnTridentTickCount;
    private static final EntityDataAccessor<Integer> RETURN_TICK = SynchedEntityData.m_135353_(ThrownPhantomDagger.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ThrownPhantomDagger.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_RED = SynchedEntityData.m_135353_(ThrownPhantomDagger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    float interia = 1.0f;
    public float uR = 195.0f;
    public float uG = 24.0f;
    public float uB = 30.0f;

    public boolean getRed() {
        return (Boolean)this.f_19804_.m_135370_(IS_RED);
    }

    public void setRed(boolean damage) {
        this.f_19804_.m_135381_(IS_RED, (Object)damage);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RETURN_TICK, (Object)20);
        this.f_19804_.m_135372_(IS_RED, (Object)false);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public ThrownPhantomDagger(EntityType<? extends ThrownPhantomDagger> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownPhantomDagger(Level pLevel, LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, float damage, float interia, int returnTick, boolean isRed) {
        super(null, pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.setInteria(interia);
        this.setReturnTick(returnTick);
        this.setRed(isRed);
    }

    @Override
    protected float getInertia() {
        return this.interia;
    }

    public void setInteria(float interia1) {
        this.interia = interia1;
    }

    protected float getReturnTick() {
        return ((Integer)this.f_19804_.m_135370_(RETURN_TICK)).intValue();
    }

    public void setReturnTick(int returnTick) {
        this.f_19804_.m_135381_(RETURN_TICK, (Object)returnTick);
    }

    protected float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setNoPhysics(boolean pNoPhysics) {
        this.f_19794_ = pNoPhysics;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 100 && !this.m_9236_().f_46443_) {
            this.m_146870_();
        }
        double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
        double dy = this.m_20186_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
        double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
        float ran = 0.4f;
        float r = (this.getRed() ? this.uR : 57.0f) / 255.0f;
        float g = (this.getRed() ? this.uG : 190.0f) / 255.0f;
        float b = (this.getRed() ? this.uB : 197.0f) / 255.0f;
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)new PhantomDaggerTrail.OrbData(r, g, b, 0.0f, 0.25f, this.m_19879_()), dx, dy, dz, 0.0, 0.0, 0.0);
        }
        if ((float)this.f_19797_ >= this.getReturnTick() && this.m_19749_() != null) {
            this.setNoPhysics(true);
            Vec3 returnPos = new Vec3(this.m_19749_().m_20185_(), this.m_19749_().m_20186_() + 1.0, this.m_19749_().m_20189_());
            Vec3 vec3 = returnPos.m_82546_(this.m_20182_());
            this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)this.interia, this.m_20189_());
            if (this.m_9236_().f_46443_) {
                this.f_19791_ = this.m_20186_();
            }
            double d0 = 0.05 * (double)this.interia;
            this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
            if (this.clientSideReturnTridentTickCount == 0) {
                // empty if block
            }
            ++this.clientSideReturnTridentTickCount;
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        TamableAnimal animal;
        Entity target = pResult.m_82443_();
        Entity owner = this.m_19749_();
        if (!(owner == null || target != owner || target instanceof TamableAnimal && (animal = (TamableAnimal)target).m_269323_() == owner)) {
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            if (target instanceof LivingEntity) {
                float m = MathUtils.toPrecent(((LivingEntity)target).m_21233_());
                boolean hurt = target.m_6469_(ModDamageTypes.causeGhostlyDamage((Entity)livingOwner, livingOwner), this.getDamage() + m);
                if (hurt) {
                    EntityUtil.applyStackingEffect((LivingEntity)target, (MobEffect)ModEffects.SOUL_FRACTURE.get(), 1, 4, MathUtils.toSeconds(10.0f));
                    livingOwner.m_5634_(3.0f + m);
                }
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        Level level;
        super.m_6532_(pResult);
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double d0 = this.m_20185_();
            double d1 = this.m_20186_() + 2.0;
            double d2 = this.m_20189_();
            server.m_8767_((ParticleOptions)(this.getRed() ? (SimpleParticleType)ModParticles.SOULSTRIKE_RED.get() : (SimpleParticleType)ModParticles.SOULSTRIKE.get()), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
        }
    }
}

