/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.AnnihilationBombTrail;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AbstractFlyingProjectile;
import net.miauczel.legendary_monsters.entity.client.ControlledAnim;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class TrackingBombEntity
extends AbstractFlyingProjectile {
    public ControlledAnim controlledAnim = new ControlledAnim(5);
    public int timer = 40;
    public boolean isFired = false;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(TrackingBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public TrackingBombEntity(EntityType<TrackingBombEntity> type, Level world) {
        super(type, world);
    }

    public TrackingBombEntity(EntityType<TrackingBombEntity> type, Level world, LivingEntity thrower, float damage, int timer) {
        super(type, world);
        this.m_5602_((Entity)thrower);
        this.setDamage(damage);
        this.setTimer(timer);
    }

    public void setTimer(int time) {
        this.timer = time;
    }

    public int getTimer() {
        return this.timer;
    }

    public boolean getIsFired() {
        return this.isFired;
    }

    public void setFired(boolean fired) {
        this.isFired = fired;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity target = result.m_82443_();
        Entity owner = this.m_19749_();
        if (owner != null && target == owner) {
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            target.m_6469_(ModDamageTypes.causeAnnihilationDamage((Entity)livingOwner, livingOwner), 12.0f);
        }
    }

    public void m_6532_(HitResult result) {
        Level level;
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double d0 = this.m_20185_();
            double d1 = this.m_20186_() + 2.0;
            double d2 = this.m_20189_();
            server.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ANNIHILATION_FLAME_STRIKE.get()), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.DIMENSIONAL_BOMB_EXPLODE_SMALL.get(), this.m_5720_(), 0.1f, 1.0f, false);
        this.m_146870_();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timer == this.timer / 2) {
            this.controlledAnim.increaseTimer();
        }
        if (this.timer <= 0) {
            this.setFired(true);
        }
        if (this.f_19797_ % 5 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.BIG_ANNIHILATION_FLAME.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_) {
            double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dy = this.m_20186_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            float ran = 0.4f;
            float r = 0.0f;
            float g = 0.7647059f + this.f_19796_.m_188501_() * ran;
            float b = 0.0f;
            this.m_9236_().m_7106_((ParticleOptions)new AnnihilationBombTrail.OrbData(r, g, b, 0.2f, 0.5f, this.m_19879_()), dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 1) {
            // empty if block
        }
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

