/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ProjectileEntityRenderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.FlyingArmorEntity;
import net.miauczel.legendary_monsters.entity.ProjectileEntityRenderer.FlyingArmorModel;
import net.miauczel.legendary_monsters.entity.client.ModModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlyingArmorRenderer
extends EntityRenderer<FlyingArmorEntity> {
    public static final ResourceLocation TEXTURE_DOWN_LEFT = new ResourceLocation("legendary_monsters", "textures/entity/the_warped_one/flying_armor/armor_projectile_2.png");
    public static final ResourceLocation TEXTURE_DOWN_RIGHT = new ResourceLocation("legendary_monsters", "textures/entity/the_warped_one/flying_armor/armor_projectile_1.png");
    public static final ResourceLocation TEXTURE_UPPER_RIGHT = new ResourceLocation("legendary_monsters", "textures/entity/the_warped_one/flying_armor/armor_projectile_3.png");
    private final FlyingArmorModel model;

    public FlyingArmorRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new FlyingArmorModel(pContext.m_174023_(ModModelLayers.FLYING_ARMOR_LAYER));
    }

    public void render(FlyingArmorEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        float secondsPerRevolution = 0.5f;
        float ticksPerRevolution = 20.0f * secondsPerRevolution;
        float radiansPerTick = (float)Math.PI * 2 / ticksPerRevolution;
        pMatrixStack.m_85837_(0.0, 1.25, 0.0);
        float rotation = pPartialTicks * radiansPerTick % ((float)Math.PI * 2);
        pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        this.model.setupAnim(pEntity, 0.0f, 0.0f, (float)pEntity.f_19797_ + pPartialTicks, 0.0f, 0.0f);
        float uniformScale = 1.0f;
        pMatrixStack.m_85841_(uniformScale, uniformScale, uniformScale);
        VertexConsumer VertexConsumer2 = pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity)));
        this.model.m_7695_(pMatrixStack, VertexConsumer2, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(FlyingArmorEntity pEntity) {
        switch ((int)pEntity.getTexture()) {
            case 1: {
                return TEXTURE_DOWN_LEFT;
            }
            case 2: {
                return TEXTURE_DOWN_RIGHT;
            }
            case 3: {
                return TEXTURE_UPPER_RIGHT;
            }
        }
        return TEXTURE_DOWN_LEFT;
    }
}

