/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai;

import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.RuinedPyramid.DuneSentinelEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.LMFallingBlockEntity;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BigCannonAttackGoal
extends MeleeAttackGoal {
    private final DuneSentinelEntity entity;
    private int attackDelay = 16;
    private int ticksUntilNextAttack = 16;
    private boolean shouldCountTillNextAttack = false;
    private boolean hasPlayedAttackSound = false;

    public BigCannonAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (DuneSentinelEntity)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 9;
        this.ticksUntilNextAttack = 9;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation() && !this.hasPlayedAttackSound) {
                SoundEvent customAttackSound = (SoundEvent)ModSounds.FATAL_MORTAR_ATTACK.get();
                this.f_25540_.m_9236_().m_5594_(null, this.f_25540_.m_20183_(), customAttackSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.entity.setAttacking(true);
                this.hasPlayedAttackSound = true;
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.hasPlayedAttackSound = false;
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 5;
            this.hasPlayedAttackSound = false;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= 12.25;
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    private void spawnFangsInPatterns(int count, double radius, double minY, double maxY, int delay) {
        for (int k = 0; k < count; ++k) {
            float angle = (float)k * (float)Math.PI * 2.0f / (float)count;
            this.spawnFangs(this.f_25540_.m_20185_() + (double)Mth.m_14089_((float)angle) * radius, this.f_25540_.m_20189_() + (double)Mth.m_14031_((float)angle) * radius, minY, maxY, angle, delay);
        }
    }

    private void spawnFangs(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double yOffset = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos belowPos = blockpos.m_7495_();
            BlockState blockstate = this.f_25540_.m_9236_().m_8055_(belowPos);
            if (!blockstate.m_60783_((BlockGetter)this.f_25540_.m_9236_(), belowPos, Direction.UP)) continue;
            if (!this.f_25540_.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_25540_.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.f_25540_.m_9236_(), blockpos)).m_83281_()) {
                yOffset = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            BlockPos pos = new BlockPos((int)this.f_25540_.m_20185_(), (int)this.f_25540_.m_20186_(), (int)this.f_25540_.m_20189_());
            BlockState blockState = this.f_25540_.m_9236_().m_8055_(pos);
            this.f_25540_.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123766_, x, (double)blockpos.m_123342_() + yOffset, z, 0.0, 0.0, 0.0);
            LMFallingBlockEntity fallingBlockEntity = new LMFallingBlockEntity(this.f_25540_.m_9236_(), this.f_25540_.m_20185_() + 0.5, this.f_25540_.m_20186_() + 1.0, this.f_25540_.m_20189_() + 0.5, blockState, 10);
            fallingBlockEntity.m_20334_(0.0, 0.2 + this.f_25540_.m_217043_().m_188500_() * 0.15, 0.0);
            this.f_25540_.m_9236_().m_7967_((Entity)fallingBlockEntity);
        }
    }

    protected void performAttack(LivingEntity pEnemy) {
        Player player;
        this.entity.performAreaAttack();
        this.m_25563_();
        this.entity.attackTargets((Entity)pEnemy);
        this.entity.ResetShootCooldown();
        this.entity.ResetShootAnimCooldown();
        if (!pEnemy.m_20096_()) {
            double knockbackRadius = 5.0;
            nearbyEntities = this.f_25540_.m_9236_().m_6249_((Entity)this.f_25540_, this.f_25540_.m_20191_().m_82400_(knockbackRadius), e -> e instanceof LivingEntity && e != this.f_25540_);
            for (Entity target : nearbyEntities) {
                double dx = target.m_20185_() - this.f_25540_.m_20185_();
                double dz = target.m_20189_() - this.f_25540_.m_20189_();
                double distance = Math.sqrt(dx * dx + dz * dz);
                double knockbackStrength = 0.5 + 0.25 * (knockbackRadius - distance);
                target.m_5997_(dx / distance * knockbackStrength, 0.3, dz / distance * knockbackStrength);
            }
        } else {
            double knockbackRadius = 5.0;
            nearbyEntities = this.f_25540_.m_9236_().m_6249_((Entity)this.f_25540_, this.f_25540_.m_20191_().m_82400_(knockbackRadius), e -> e instanceof LivingEntity && e != this.f_25540_);
            for (Entity target : nearbyEntities) {
                double dx = target.m_20185_() - this.f_25540_.m_20185_();
                double dz = target.m_20189_() - this.f_25540_.m_20189_();
                double distance = Math.sqrt(dx * dx + dz * dz);
                double knockbackStrength = 1.0 + 0.5 * (knockbackRadius - distance);
                target.m_5997_(dx / distance * knockbackStrength, 0.4, dz / distance * knockbackStrength);
            }
        }
        Level level = this.f_25540_.m_9236_();
        int standingOnY = Mth.m_14107_((double)this.f_25540_.m_20186_());
        this.spawnFangsInPatterns(6, 2.5, standingOnY, 1.0, 0);
        this.spawnFangsInPatterns(11, 3.5, standingOnY, 1.0, 2);
        this.spawnFangsInPatterns(14, 4.5, standingOnY, 1.0, 4);
        this.spawnFangsInPatterns(19, 5.5, standingOnY, 1.0, 6);
        this.spawnFangsInPatterns(26, 6.5, standingOnY, 1.0, 8);
        if (!this.f_25540_.m_5448_().m_21254_()) {
            // empty if block
        }
        if (pEnemy instanceof Player && (player = (Player)pEnemy).m_21254_() && (player.m_21205_().m_41720_() instanceof ShieldItem || player.m_21206_().m_41720_() instanceof ShieldItem)) {
            Item shieldItem;
            Item item = shieldItem = player.m_21205_().m_41720_() instanceof ShieldItem ? player.m_21205_().m_41720_() : player.m_21206_().m_41720_();
            if (!player.m_36335_().m_41519_(shieldItem)) {
                player.m_36335_().m_41524_(shieldItem, 40);
                if (player.m_21254_()) {
                    player.m_5810_();
                }
            }
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        this.entity.setShooting(false);
        super.m_8041_();
        this.hasPlayedAttackSound = false;
    }
}

