/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.ai.navigation;

import java.util.Objects;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathfinder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class ModPathNavigation
extends GroundPathNavigation {
    public ModPathNavigation(Mob mob, Level world) {
        super(mob, world);
    }

    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new WalkNodeEvaluator();
        this.f_26508_.m_77351_(true);
        return new ModPathfinder(this.f_26508_, maxVisitedNodes);
    }

    protected void m_7636_() {
        Path path = Objects.requireNonNull(this.f_26496_);
        Vec3 entityPos = this.m_7475_();
        int pathLength = path.m_77398_();
        for (int i = path.m_77399_(); i < path.m_77398_(); ++i) {
            if ((double)path.m_77375_((int)i).f_77272_ == Math.floor(entityPos.f_82480_)) continue;
            pathLength = i;
            break;
        }
        Vec3 base = entityPos.m_82520_((double)(-this.f_26494_.m_20205_() * 0.5f), 0.0, (double)(-this.f_26494_.m_20205_() * 0.5f));
        Vec3 max = base.m_82520_((double)this.f_26494_.m_20205_(), (double)this.f_26494_.m_20206_(), (double)this.f_26494_.m_20205_());
        if (this.tryShortcut(path, new Vec3(this.f_26494_.m_20185_(), this.f_26494_.m_20186_(), this.f_26494_.m_20189_()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.f_26494_.m_20205_() * 0.5f))) {
            path.m_77393_(path.m_77399_() + 1);
        }
        this.f_26494_.m_7678_(entityPos.f_82479_, entityPos.f_82480_, entityPos.f_82481_, this.f_26494_.m_146908_(), this.f_26494_.m_146909_());
    }

    private boolean isAt(Path path, float threshold) {
        Vec3 pathPos = path.m_77380_((Entity)this.f_26494_);
        return Math.abs(this.f_26494_.m_20185_() - pathPos.f_82479_) < (double)threshold && Math.abs(this.f_26494_.m_20189_() - pathPos.f_82481_) < (double)threshold && Math.abs(this.f_26494_.m_20186_() - pathPos.f_82480_) < 1.0;
    }

    private boolean atElevationChange(Path path) {
        int curr = path.m_77399_();
        int end = Math.min(path.m_77398_(), curr + Mth.m_14167_((float)(this.f_26494_.m_20205_() * 0.5f)) + 1);
        int currY = path.m_77375_((int)curr).f_77272_;
        for (int i = curr + 1; i < end; ++i) {
            if (path.m_77375_((int)i).f_77272_ == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base, Vec3 max) {
        int i = pathLength;
        while (--i > path.m_77399_()) {
            Vec3 vec = path.m_77382_((Entity)this.f_26494_, i).m_82546_(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.m_77393_(i);
            return false;
        }
        return true;
    }

    private boolean sweep(Vec3 vec, Vec3 base, Vec3 max) {
        float t = 0.0f;
        float max_t = (float)vec.m_82553_();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] tr = new float[3];
        int[] ldi = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (int i = 0; i < 3; ++i) {
            float value = ModPathNavigation.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = ModPathNavigation.element(dir ? max : base, i);
            tr[i] = ModPathNavigation.element(dir ? base : max, i);
            ldi[i] = ModPathNavigation.leadEdgeToInt(lead, step[i]);
            tri[i] = ModPathNavigation.trailEdgeToInt(tr[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = Mth.m_14154_((float)(max_t / value));
            float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        return true;
    }

    protected boolean canUpdatePath(BlockPathTypes pathType) {
        if (pathType == BlockPathTypes.WATER) {
            return false;
        }
        return pathType != BlockPathTypes.LAVA && pathType != BlockPathTypes.OPEN;
    }

    static int leadEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(Vec3 v, int i) {
        switch (i) {
            case 0: {
                return (float)v.f_82479_;
            }
            case 1: {
                return (float)v.f_82480_;
            }
            case 2: {
                return (float)v.f_82481_;
            }
        }
        return 0.0f;
    }
}

