/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.client.Render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.LightningBoltEntity;
import net.miauczel.legendary_monsters.entity.client.ModModelLayers;
import net.miauczel.legendary_monsters.entity.client.Model.LightningStrikeModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class LightningRenderer
extends EntityRenderer<LightningBoltEntity> {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final LightningStrikeModel model;
    private final float linearity;

    public LightningRenderer(EntityRendererProvider.Context context, float linearity) {
        super(context);
        this.linearity = linearity;
        this.model = new LightningStrikeModel(context.m_174023_(ModModelLayers.LIGHTNING_STRIKE_LAYER));
    }

    public void render(LightningBoltEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float $$10;
        float $$7;
        matrixStack.m_85836_();
        float $$6 = entity.getAnimationProgress(partialTicks);
        if ($$6 != 0.0f) {
            $$7 = 2.0f;
            if ($$6 > 0.9f) {
                $$7 *= (1.0f - $$6) / 0.1f;
            }
            $$10 = 2.0f;
            if ($$6 > 0.9f) {
                $$10 *= (1.0f - $$6) / 0.1f;
            }
            this.model.m_6973_(entity, $$6, 0.0f, 0.0f, entity.m_146908_(), entity.m_146909_());
            VertexConsumer vertexconsumer = buffer.m_6299_(this.model.m_103119_(new ResourceLocation("legendary_monsters", "textures/entity/falling_cloud_angry.png")));
            this.model.m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85841_(-$$7, -$$7, -$$7);
        }
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        if ($$6 != 0.0f) {
            $$7 = 1.0f;
            if ($$6 > 0.9f) {
                $$7 *= (1.0f - $$6) / 0.1f;
            }
            $$10 = 2.0f;
            if ($$6 > 0.9f) {
                $$10 *= (1.0f - $$6) / 0.1f;
            }
        }
        if ($$6 != 0.0f) {
            double entityZ;
            double dirZ;
            Minecraft mc = Minecraft.m_91087_();
            double playerX = mc.f_91074_.m_20185_();
            double playerZ = mc.f_91074_.m_20189_();
            double entityX = entity.m_20185_();
            double dirX = playerX - entityX;
            double magnitude = Math.sqrt(dirX * dirX + (dirZ = playerZ - (entityZ = entity.m_20189_())) * dirZ);
            if (magnitude != 0.0) {
                dirX /= magnitude;
                dirZ /= magnitude;
            }
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
            float startX = 0.0f;
            float startZ = 0.0f;
            int i = 0;
            while ((float)i < 7.5f) {
                float maxDeviation = (1.0f - this.linearity) * 2.0f;
                float endX = startX + RANDOM.m_188501_() * maxDeviation - maxDeviation / 2.0f;
                float endZ = startZ + RANDOM.m_188501_() * maxDeviation - maxDeviation / 2.0f;
                this.render3DSegment(matrixStack.m_85850_().m_252922_(), vertexConsumer, startX, startZ, i, endX, endZ, i + 1, dirX, dirZ, 0.8f, 0.8f, 1.0f, 0.7f);
                startX = endX;
                startZ = endZ;
                ++i;
            }
        }
        matrixStack.m_85849_();
        packedLight = 0xF000F0;
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private void render3DSegment(Matrix4f matrix, VertexConsumer consumer, float startX, float startZ, int startY, float endX, float endZ, int endY, double dirX, double dirZ, float red, float green, float blue, float aplha) {
        float thickness = 0.1f;
        float perpX = (float)(-dirZ);
        float perpZ = (float)dirX;
        this.renderQuad(matrix, consumer, startX, startZ, startY, endX, endZ, endY, red, green, blue, aplha, perpX *= thickness, perpZ *= thickness);
        this.renderQuad(matrix, consumer, startX, startZ, startY, endX, endZ, endY, red, green, blue, aplha, -perpX, -perpZ);
    }

    private void renderQuad(Matrix4f matrix, VertexConsumer consumer, float x1, float z1, int y1, float x2, float z2, int y2, float red, float green, float blue, float alpha, float perpX, float perpZ) {
        consumer.m_252986_(matrix, x1 - perpX, (float)y1 * 1.0f, z1 - perpZ).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x2 - perpX, (float)y2 * 1.0f, z2 - perpZ).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x2 + perpX, (float)y2 * 1.0f, z2 + perpZ).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x1 + perpX, (float)y1 * 1.0f, z1 + perpZ).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(LightningBoltEntity entity) {
        return new ResourceLocation("legendary_monsters", "textures/entity/cloud_golem/model.png");
    }
}

