/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.client.Render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.AnimatedEntity.SoulShieldEntity;
import net.miauczel.legendary_monsters.entity.client.ModModelLayers;
import net.miauczel.legendary_monsters.entity.client.Model.SoulShieldModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SoulShieldRenderer
extends EntityRenderer<SoulShieldEntity> {
    private static final ResourceLocation BASE_LAYER = new ResourceLocation("legendary_monsters", "textures/entity/posessed_paladin/soul_shield.png");
    private static final ResourceLocation RED_LAYER = new ResourceLocation("legendary_monsters", "textures/entity/posessed_paladin/soul_shield_red.png");
    private final SoulShieldModel<SoulShieldEntity> model;

    public SoulShieldRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new SoulShieldModel(pContext.m_174023_(ModModelLayers.SOUL_SHIELD_LAYER));
    }

    public void render(SoulShieldEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        double dx = (double)pEntity.getDestinationX() - pEntity.m_20185_();
        double dy = (double)pEntity.getDestinationY() - pEntity.m_20186_();
        double dz = (double)pEntity.getDestinationZ() - pEntity.m_20189_();
        float yawDeg = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        float horizontal = (float)Math.sqrt(dx * dx + dz * dz);
        float pitchDeg = -((float)Math.toDegrees(Math.atan2(dy, horizontal)));
        float yawRad = (float)Math.toRadians(yawDeg);
        float pitchRad = (float)Math.toRadians(pitchDeg);
        float animationProgress = Math.min(pEntity.controlledAnim.getAnimationFraction(), 1.0f);
        float f1 = 1.0f - animationProgress;
        pMatrixStack.m_85836_();
        float uniformScale = 1.5f;
        pMatrixStack.m_85841_(uniformScale, uniformScale, uniformScale);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252961_(-yawRad + (float)Math.PI));
        pMatrixStack.m_252781_(Axis.f_252529_.m_252961_(-pitchRad));
        pMatrixStack.m_252781_(Axis.f_252403_.m_252961_((float)Math.PI));
        pMatrixStack.m_85837_(0.0, -1.5, 0.0);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag2 = minecraft.m_91314_((Entity)pEntity);
        RenderType rendertype = this.getRenderType(pEntity, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = pBuffer.m_6299_(rendertype);
            int i = SoulShieldRenderer.getOverlayCoords(pEntity, this.getWhiteOverlayProgress(pEntity, pPartialTicks));
            this.model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, i, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        VertexConsumer VertexConsumer2 = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pEntity)));
        this.model.setupAnim(pEntity, 0.0f, 0.0f, (float)pEntity.f_19797_ + pPartialTicks, 0.0f, 0.0f);
        this.model.m_7695_(pMatrixStack, VertexConsumer2, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, Mth.m_14036_((float)(f1 - 0.5f), (float)0.0f, (float)1.0f));
        System.out.println("SHIELD: " + Mth.m_14036_((float)(f1 - 0.5f), (float)0.0f, (float)1.0f));
        System.out.println("F1: " + f1);
        pMatrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(SoulShieldEntity pEntity) {
        return pEntity.getRed() ? RED_LAYER : BASE_LAYER;
    }

    @Nullable
    protected RenderType getRenderType(SoulShieldEntity pLivingEntity, boolean pGlowing) {
        ResourceLocation resourcelocation = this.getTextureLocation(pLivingEntity);
        return pGlowing ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected float getWhiteOverlayProgress(SoulShieldEntity entity, float pPartialTicks) {
        return 0.0f;
    }

    public static int getOverlayCoords(SoulShieldEntity pLivingEntity, float pU) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)pU), (int)OverlayTexture.m_118096_((boolean)true));
    }
}

