/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.client.Render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.miauczel.legendary_monsters.client.RenderUtils;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.TheObliterator.TheObliteratorEntity;
import net.miauczel.legendary_monsters.entity.client.ModModelLayers;
import net.miauczel.legendary_monsters.entity.client.Model.TheObliteratorModel;
import net.miauczel.legendary_monsters.entity.client.Render.LMRenderTypes;
import net.miauczel.legendary_monsters.entity.client.layer.TheObliteratorFlameyBladesLayer;
import net.miauczel.legendary_monsters.entity.client.layer.TheObliteratorGrabLayer;
import net.miauczel.legendary_monsters.entity.client.layer.TheObliteratorPowerBallInnerLayer;
import net.miauczel.legendary_monsters.entity.client.layer.TheObliteratorPowerBallOuterLayer;
import net.miauczel.legendary_monsters.entity.client.layer.TheObliteratorUltimateFlame;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix4f;

public class TheObliteratorRenderer
extends MobRenderer<TheObliteratorEntity, TheObliteratorModel<TheObliteratorEntity>> {
    private static final ResourceLocation ARMORED = new ResourceLocation("legendary_monsters", "textures/entity/the_warped_one/the_warped_one.png");
    private static final ResourceLocation NO_ARMOR = new ResourceLocation("legendary_monsters", "textures/entity/the_warped_one/the_warped_one_no_armor.png");
    private static final ResourceLocation PHASE_3 = new ResourceLocation("legendary_monsters", "textures/entity/the_warped_one/the_warped_one_phase_3.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public TheObliteratorRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new TheObliteratorModel(pContext.m_174023_(ModModelLayers.THE_OBLITERATOR_LAYER)), 2.25f);
        this.m_115326_(new TheObliteratorUltimateFlame((RenderLayerParent<TheObliteratorEntity, TheObliteratorModel<TheObliteratorEntity>>)this));
        this.m_115326_(new TheObliteratorFlameyBladesLayer((RenderLayerParent<TheObliteratorEntity, TheObliteratorModel<TheObliteratorEntity>>)this));
        this.m_115326_(new TheObliteratorPowerBallInnerLayer(this));
        this.m_115326_(new TheObliteratorPowerBallOuterLayer(this));
        this.m_115326_(new TheObliteratorGrabLayer((RenderLayerParent<TheObliteratorEntity, TheObliteratorModel<TheObliteratorEntity>>)this, pContext.m_174022_()));
    }

    public ResourceLocation getTextureLocation(TheObliteratorEntity pEntity) {
        if (pEntity.getIsThirdPhase()) {
            return PHASE_3;
        }
        if (pEntity.getIsSecondPhase()) {
            return NO_ARMOR;
        }
        return ARMORED;
    }

    public void render(TheObliteratorEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float bodyXRotDeg = (((TheObliteratorModel)this.f_115290_).body.f_104203_ * 57.295776f + ((TheObliteratorModel)this.f_115290_).big_cube.f_104203_ * 57.295776f + ((TheObliteratorModel)this.f_115290_).root.f_104203_ * 57.295776f) * 1.0f;
        float bodyYRotDeg = (((TheObliteratorModel)this.f_115290_).body.f_104204_ * 57.295776f + ((TheObliteratorModel)this.f_115290_).big_cube.f_104204_ * 57.295776f + ((TheObliteratorModel)this.f_115290_).root.f_104204_ * 57.295776f) * 1.0f;
        pEntity.setPartXRot(-bodyXRotDeg);
        pEntity.setPartYRot(-bodyYRotDeg);
        pMatrixStack.m_85841_(0.8f, 0.8f, 0.8f);
        pMatrixStack.m_85836_();
        float renderProgress = (float)(pEntity.renderProgress * 5) + pPartialTicks;
        float yaw = -pEntity.f_20883_ + 90.0f + renderProgress;
        float yaw2 = -pEntity.f_20883_ + 180.0f + renderProgress;
        float yaw3 = -pEntity.f_20883_ + 270.0f + renderProgress;
        float yaw4 = -pEntity.f_20883_ + renderProgress;
        float f = Mth.m_14089_((float)(pEntity.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(pEntity.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)pEntity.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float vec = 0.0f;
        float offset = 0.0f;
        double x = 0.0 + (double)vec * vecX + (double)(f * offset);
        double z = 0.0 + (double)vec * vecZ + (double)(f1 * offset);
        VertexConsumer vertexConsumer = pBuffer.m_6299_(LMRenderTypes.LIGHTNING1);
        if (pEntity.getAttackState() == 46 && pEntity.attackTicks < 46 && pEntity.attackTicks > 12) {
            float uniA = 0.35f;
            float uniY = 2.5f;
            RenderUtils.renderPivotedQuad(16.0f, 0.25f, x, uniY, z, 0.0, yaw, 0.0, vertexConsumer, pMatrixStack, OverlayTexture.f_118083_, pPackedLight, 0.25f, 1.0f, 0.25f, uniA);
            RenderUtils.renderPivotedQuad(16.0f, 0.25f, x, uniY, z, 0.0, yaw2, 0.0, vertexConsumer, pMatrixStack, OverlayTexture.f_118083_, pPackedLight, 0.25f, 1.0f, 0.25f, uniA);
            RenderUtils.renderPivotedQuad(16.0f, 0.25f, x, uniY, z, 0.0, yaw3, 0.0, vertexConsumer, pMatrixStack, OverlayTexture.f_118083_, pPackedLight, 0.25f, 1.0f, 0.25f, uniA);
            RenderUtils.renderPivotedQuad(16.0f, 0.25f, x, uniY, z, 0.0, yaw4, 0.0, vertexConsumer, pMatrixStack, OverlayTexture.f_118083_, pPackedLight, 0.25f, 1.0f, 0.25f, uniA);
        }
        pMatrixStack.m_85849_();
        if (pEntity.attackTicks > 0 && pEntity.attackTicks < 45 && pEntity.getAttackState() == 2) {
            float f5 = ((float)pEntity.attackTicks + pPartialTicks) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            RandomSource randomsource = RandomSource.m_216335_((long)432L);
            VertexConsumer vertexconsumer2 = pBuffer.m_6299_(RenderType.m_110502_());
            pMatrixStack.m_85836_();
            pMatrixStack.m_85837_(0.0, 3.0 + (double)pEntity.getAttackTicks() * 0.1, 0.0);
            float duration = 40.0f;
            float t = Mth.m_14036_((float)(((float)pEntity.attackTicks + pPartialTicks) / duration), (float)0.0f, (float)1.0f);
            float scale = (float)Math.sin(Math.PI * (double)t);
            scale = Mth.m_14036_((float)scale, (float)0.0f, (float)1.0f);
            pMatrixStack.m_85841_(scale, scale, scale);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 30.0f) {
                pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
                pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
                pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f));
                pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
                pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
                pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f + f5 * 90.0f));
                float f3 = randomsource.m_188501_() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = randomsource.m_188501_() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = pMatrixStack.m_85850_().m_252922_();
                int j = (int)(255.0f * (1.0f - f7));
                TheObliteratorRenderer.vertex01(vertexconsumer2, matrix4f, j);
                TheObliteratorRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                TheObliteratorRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                TheObliteratorRenderer.vertex01(vertexconsumer2, matrix4f, j);
                TheObliteratorRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                TheObliteratorRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                TheObliteratorRenderer.vertex01(vertexconsumer2, matrix4f, j);
                TheObliteratorRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                TheObliteratorRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                ++i;
            }
            pMatrixStack.m_85849_();
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public void renderWarningQuads(LivingEntity entity) {
    }

    private static void vertex01(VertexConsumer pConsumer, Matrix4f pMatrix, int pAlpha) {
        pConsumer.m_252986_(pMatrix, 0.0f, 4.0f, 0.0f).m_6122_(0, 255, 0, pAlpha).m_5752_();
    }

    private static void vertex2(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253704_, float p_253701_) {
        pConsumer.m_252986_(pMatrix, -HALF_SQRT_3 * p_253701_, p_253704_, -0.5f * p_253701_).m_6122_(0, 255, 0, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253729_, float p_254030_) {
        pConsumer.m_252986_(pMatrix, -HALF_SQRT_3 * p_254030_, p_253729_, -0.5f * p_254030_).m_6122_(0, 255, 0, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer pConsumer, Matrix4f pMatrix, float p_253649_, float p_253694_) {
        pConsumer.m_252986_(pMatrix, 0.0f, p_253649_, 1.0f * p_253694_).m_6122_(0, 255, 0, 0).m_5752_();
    }
}

