/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.event;

import java.util.List;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.BlockUtils;
import net.miauczel.legendary_monsters.util.ModSavedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="legendary_monsters", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onCheckSpawn(MobSpawnEvent.SpawnPlacementCheck event) {
        if (event.getEntityType() != ModEntities.FLAMEBORN_GUARD.get()) {
            return;
        }
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
        if (!ModSavedData.get(serverLevel).isDefeatedObliterator()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingAttackEvent event) {
        DamageSource damageSource = event.getSource();
        LivingEntity attackedEntity = event.getEntity();
        Entity attacker1 = damageSource.m_7640_();
        if (attacker1 instanceof Player) {
            ItemStack itemStack;
            Player attacker = (Player)attacker1;
            if (damageSource.m_269150_().m_203565_(ModDamageTypes.ANNIHILATION)) {
                return;
            }
            if (attacker != null && attackedEntity != null && attacker.f_19789_ > 0.0f && attacker.m_36403_(0.5f) >= 1.0f && (itemStack = attacker.m_6844_(EquipmentSlot.LEGS)).m_150930_((Item)ModItems.ANNIHILATOR_LEGGINGS.get()) && attacker.m_217043_().m_188502_() * 100 < 25) {
                AttributeInstance attributeInstance = attacker.m_21051_(Attributes.f_22281_);
                if (attacker.m_21204_().m_22171_(Attributes.f_22281_) && attributeInstance != null) {
                    float damage = (float)attributeInstance.m_22135_();
                    float uBox = 3.0f;
                    BlockPos blockPos = BlockUtils.blockPosVec3(attacker.m_20182_());
                    AABB aabb = new AABB(blockPos).m_82400_((double)uBox);
                    List list = attacker.m_9236_().m_45976_(LivingEntity.class, aabb);
                    for (LivingEntity entity : list) {
                        if (entity == attacker || entity == attackedEntity) continue;
                        entity.m_6469_(new DamageSource((Holder)attackedEntity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ModDamageTypes.ANNIHILATION), (Entity)attacker), damage / 2.0f);
                    }
                    Level level = attacker.m_9236_();
                    level.m_5594_(null, BlockUtils.blockPosVec3(attackedEntity.m_20182_()), (SoundEvent)ModSounds.ENERGY_EXPLOSION.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    double d1 = attackedEntity.m_20185_();
                    double d2 = attackedEntity.m_20186_();
                    double d3 = attackedEntity.m_20189_();
                    ParticleOptions particleOptions2 = (ParticleOptions)ModParticles.ANNIHILATION_FLAME_STRIKE.get();
                    Circle.RingData particleOptions = new Circle.RingData(0.0f, 1.5707964f, 30, 0.0f, 1.0f, 0.0f, 1.0f, 100.0f, false, Circle.EnumRingBehavior.GROW);
                    level.m_7106_((ParticleOptions)particleOptions, d1, d2, d3, 0.0, 0.0, 0.0);
                    float multiplier = 3.0f;
                    float size = 2.0f;
                    float amountOfFlames = 7.0f;
                    int k = 0;
                    while ((float)k < amountOfFlames) {
                        float f3 = (float)k * (float)Math.PI * size / amountOfFlames + (float)Math.PI * size / 10.0f;
                        int standingOnY = Mth.m_14107_((double)d2);
                        level.m_7106_(particleOptions2, d1 + (double)(Mth.m_14089_((float)f3) * multiplier), d2 + 2.0, d3 + (double)(Mth.m_14031_((float)f3) * multiplier), 0.0, 0.0, 0.0);
                        ++k;
                    }
                }
            }
        }
    }
}

