/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item;

import net.miauczel.legendary_monsters.item.custom.customArmor.ModArmorMaterials;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="legendary_monsters", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModArmorItem
extends ArmorItem {
    private static final MobEffectInstance MOSSY_ARMOR_EFFECT = new MobEffectInstance(MobEffects.f_19611_, 200, 1, false, false, true);

    public ModArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && !(player = event.player).m_9236_().m_5776_() && ModArmorItem.hasMossyChestplate(player)) {
            ModArmorItem.addMossyArmorEffect(player);
        }
    }

    private static boolean hasMossyChestplate(Player player) {
        ItemStack chestplateStack = player.m_150109_().m_36052_(2);
        return !chestplateStack.m_41619_() && chestplateStack.m_41720_() instanceof ModArmorItem && ((ModArmorItem)chestplateStack.m_41720_()).m_40401_() == ModArmorMaterials.MOSSY;
    }

    private static void addMossyArmorEffect(Player player) {
        boolean hasPlayerEffect = player.m_21023_(MOSSY_ARMOR_EFFECT.m_19544_());
        if (!hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(MOSSY_ARMOR_EFFECT));
        }
    }
}

