/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom;

import java.util.List;
import java.util.function.Consumer;
import net.miauczel.legendary_monsters.client.ModBlockEntityWithoutLevelRenderer;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationBeamEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationBombEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class AtomSplitterItem
extends Item {
    public AtomSplitterItem(Item.Properties pProperties) {
        super(pProperties.m_41503_(4));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.isUsable(itemstack)) {
            ItemStack itemStack = ((Item)ModItems.BOTTLE_OF_ANNIHILATION.get()).m_7968_();
            if (player.m_150109_().m_36063_(itemStack) || player.m_150110_().f_35937_) {
                if (!player.m_9236_().f_46443_) {
                    itemstack.m_41721_(0);
                    player.m_150109_().m_6596_();
                }
                if (!player.m_150110_().f_35937_) {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        ItemStack s = player.m_150109_().m_8020_(i);
                        if (!s.m_150930_((Item)ModItems.BOTTLE_OF_ANNIHILATION.get()) || s.m_41613_() < 2) continue;
                        s.m_41774_(2);
                        break;
                    }
                }
                if (!player.m_36335_().m_41519_((Item)this)) {
                    player.m_36335_().m_41524_((Item)this, 10);
                }
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        if (player.m_36335_().m_41519_((Item)this) || this.isUsable(itemstack)) {
            // empty if block
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ModBlockEntityWithoutLevelRenderer.INSTANCE;
            }
        });
    }

    public boolean isUsable(ItemStack itemStack) {
        return itemStack.m_41773_() < itemStack.m_41776_() - 1;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        int useDuration = this.m_8105_(pStack) - pRemainingUseDuration;
        if (useDuration == 3) {
            pLivingEntity.m_5496_((SoundEvent)ModSounds.ANNIHILATION_LASER_CHARGE.get(), 3.0f, 1.5f);
        }
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (this.isUsable(stack) && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int useDuration = this.m_8105_(stack) - timeLeft;
            if (useDuration > 20) {
                stack.m_41622_(1, entityLiving, e -> e.m_21166_(EquipmentSlot.MAINHAND));
                if (!player.m_36335_().m_41519_((Item)this)) {
                    player.m_36335_().m_41524_((Item)this, 30);
                }
                if (!player.m_6144_()) {
                    entityLiving.m_5496_((SoundEvent)ModSounds.ANNIHILATION_LASER_SINGLE_SHOOT.get(), 3.0f, 1.0f);
                    Vec3 entityPosition = entityLiving.m_20182_();
                    CameraShakeEntity.cameraShake(entityLiving.m_9236_(), entityPosition, 30.0f, 0.1f, 5, 5);
                    AnnihilationBeamEntity energyBeamEntity = new AnnihilationBeamEntity((EntityType<? extends AnnihilationBeamEntity>)((EntityType)ModEntities.ANNIHILATION_BEAM.get()), entityLiving.m_9236_(), entityLiving, entityLiving.m_20185_(), entityLiving.m_20186_() + 1.0, entityLiving.m_20189_(), (float)((double)(entityLiving.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-entityLiving.m_146909_()) * Math.PI / 180.0), 10, 12.0f, 1.0f, 1, false, 0.0f, 0.0f, 0.0f, false, 30.0f);
                    energyBeamEntity.setRadius(30.0f);
                    entityLiving.m_9236_().m_7967_((Entity)energyBeamEntity);
                } else {
                    entityLiving.m_5496_((SoundEvent)ModSounds.THE_WARPED_ONE_SHOOT.get(), 3.0f, 1.0f);
                    this.shootAnnihilationBomb(player, 1.0f, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                }
            }
        }
    }

    public void shootAnnihilationBomb(Player player, float velocity, double x, double y, double z) {
        AnnihilationBombEntity chorusBomb = new AnnihilationBombEntity((EntityType<AnnihilationBombEntity>)((EntityType)ModEntities.ANNIHILATION_BOMB_ENTITY.get()), player.m_9236_(), (LivingEntity)player, 10.0f, 16, false);
        chorusBomb.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity * 1.0f, 1.0f);
        chorusBomb.m_20343_(x, y, z);
        chorusBomb.m_5602_((Entity)player);
        player.m_9236_().m_7967_((Entity)chorusBomb);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.atom_splitter1"));
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.atom_splitter2"));
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.atom_splitter3"));
    }
}

