/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom;

import java.util.List;
import net.miauczel.legendary_monsters.item.ModArmorItem;
import net.miauczel.legendary_monsters.item.custom.WitheredRibcageItem;
import net.miauczel.legendary_monsters.item.custom.customArmor.ModArmorMaterials;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="legendary_monsters", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DinosaurBoneHelmet
extends ArmorItem {
    private static final MobEffectInstance MOSSY_ARMOR_EFFECT = new MobEffectInstance(MobEffects.f_19611_, 200, 1, false, false, true);
    private static final MobEffectInstance BONE_EFFECT = new MobEffectInstance(MobEffects.f_19611_, 200, 1, false, false, true);

    public DinosaurBoneHelmet(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static boolean hasMossyChestplate(Player player) {
        ItemStack chestplateStack = (ItemStack)player.m_150109_().f_35975_.get(2);
        return !chestplateStack.m_41619_() && chestplateStack.m_41720_() instanceof ModArmorItem && ((ModArmorItem)chestplateStack.m_41720_()).m_40401_() == ModArmorMaterials.DINOSAUR_BONE;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack chestplateItemStack;
        Player player;
        if (event.phase == TickEvent.Phase.START && !(player = event.player).m_9236_().m_5776_() && !(chestplateItemStack = (ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_())).m_41619_() && chestplateItemStack.m_41720_() instanceof WitheredRibcageItem) {
            if (DinosaurBoneHelmet.hasMossyChestplate(player)) {
                DinosaurBoneHelmet.addMossyArmorEffect(player);
            } else {
                DinosaurBoneHelmet.removePoisonEffect(player);
            }
        }
    }

    private static void addMossyArmorEffect(Player player) {
        boolean hasPlayerEffect = player.m_21023_(BONE_EFFECT.m_19544_());
        if (!hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(BONE_EFFECT));
        }
    }

    private static void removePoisonEffect(Player player) {
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237113_((String)"\u00a76SPECIAL ABILITY: \u00a76\u00a7l[HEAD PROTECTION] \u00a76 25% chance of ignoring damage from arrows or"));
        list.add((Component)Component.m_237113_((String)"\u00a76mob projectiles"));
    }
}

