/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.Particle.custom.MovingTrailParticle;
import net.miauczel.legendary_monsters.client.ModBlockEntityWithoutLevelRenderer;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.AnnihilationPortalEntity;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.EntityUtil;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;

public class TheTesseractItem
extends SwordItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public static final UUID ATTACK_RANGE_MODIFIER_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    public TheTesseractItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 13.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.8f, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(ATTACK_RANGE_MODIFIER_UUID, "Tool modifier2", 1.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ModBlockEntityWithoutLevelRenderer.INSTANCE;
            }
        });
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public float maxChargeTick() {
        return 30.0f;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        Vec3 diff;
        LivingEntity livingentity;
        AABB aabb;
        Vec3 vec3;
        BlockPos blockPos;
        double dz;
        float multiplier;
        float f3;
        int k;
        int useDuration = this.m_8105_(pStack) - pRemainingUseDuration;
        if ((float)useDuration == this.maxChargeTick()) {
            pLivingEntity.m_5496_((SoundEvent)ModSounds.ULTIMATE_FLAME_IMPACT.get(), 1.0f, 1.0f);
        }
        CameraShakeEntity.cameraShake(pLivingEntity.m_9236_(), pLivingEntity.m_20182_(), 5.0f, 0.025f, 1, 1);
        for (k = 0; k < 3; ++k) {
            float d1 = Mth.m_14116_((float)k);
            float ran = 0.4f;
            float r = 0.0f;
            float g = 0.7647059f + pLivingEntity.m_217043_().m_188501_() * ran;
            float b = 0.0f;
            if (!pLevel.f_46443_) continue;
            pLivingEntity.m_9236_().m_7106_((ParticleOptions)new MovingTrailParticle.TrailData(r, g, b, 0.2f, 0.1f), pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), (double)Mth.m_14031_((float)k), 0.0, (double)(d1 * 0.01f));
        }
        if (useDuration % 15 == 0) {
            Circle.RingData particleOptions = new Circle.RingData(0.0f, 1.5707964f, 20, 0.0f, 1.0f, 0.0f, 1.0f, 150.0f, false, Circle.EnumRingBehavior.SHRINK);
            if (pLevel.f_46443_) {
                pLevel.m_7106_((ParticleOptions)particleOptions, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        for (k = 0; k < 5; ++k) {
            f3 = (float)k * (float)Math.PI * 2.0f / 5.0f + 0.62831855f;
            multiplier = 4.0f;
            double dx = pLivingEntity.m_20185_() + (double)(Mth.m_14089_((float)f3) * multiplier);
            double dy = pLivingEntity.m_20186_();
            dz = pLivingEntity.m_20189_() + (double)(Mth.m_14031_((float)f3) * multiplier);
            blockPos = new BlockPos((int)dx, (int)dy, (int)dz);
            vec3 = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            aabb = new AABB(blockPos);
            for (Entity e : pLivingEntity.m_9236_().m_45933_((Entity)pLivingEntity, aabb.m_82400_(1.5))) {
                if (!(e instanceof LivingEntity)) continue;
                livingentity = (LivingEntity)e;
                if (e == pLivingEntity || e instanceof Player && ((Player)e).m_150110_().f_35934_) continue;
                diff = livingentity.m_20182_().m_82546_(vec3.m_82520_(0.0, 0.0, 0.0));
                diff = diff.m_82541_().m_82490_(0.1);
                livingentity.m_20256_(livingentity.m_20184_().m_82546_(diff));
                EntityUtil.applyPlayerDeltaMovement(livingentity);
            }
        }
        for (k = 0; k < 5; ++k) {
            f3 = (float)k * (float)Math.PI * 2.0f / 5.0f + 0.62831855f;
            multiplier = 7.5f;
            double dx = pLivingEntity.m_20185_() + (double)(Mth.m_14089_((float)f3) * multiplier);
            double dy = pLivingEntity.m_20186_();
            dz = pLivingEntity.m_20189_() + (double)(Mth.m_14031_((float)f3) * multiplier);
            blockPos = new BlockPos((int)dx, (int)dy, (int)dz);
            vec3 = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            aabb = new AABB(blockPos);
            for (Entity e : pLivingEntity.m_9236_().m_45933_((Entity)pLivingEntity, aabb.m_82400_(1.5))) {
                if (!(e instanceof LivingEntity)) continue;
                livingentity = (LivingEntity)e;
                if (e == pLivingEntity || e instanceof Player && ((Player)e).m_150110_().f_35934_) continue;
                diff = livingentity.m_20182_().m_82546_(vec3.m_82520_(0.0, 0.0, 0.0));
                diff = diff.m_82541_().m_82490_(0.1);
                livingentity.m_20256_(livingentity.m_20184_().m_82546_(diff));
                EntityUtil.applyPlayerDeltaMovement(livingentity);
            }
        }
        double dx = pLivingEntity.m_20185_();
        double dy = pLivingEntity.m_20186_();
        double dz2 = pLivingEntity.m_20189_();
        BlockPos blockPos2 = new BlockPos((int)dx, (int)dy, (int)dz2);
        Vec3 vec32 = new Vec3((double)blockPos2.m_123341_(), (double)blockPos2.m_123342_(), (double)blockPos2.m_123343_());
        AABB aabb2 = new AABB(blockPos2);
        for (Entity e : pLivingEntity.m_9236_().m_45933_((Entity)pLivingEntity, aabb2.m_82400_(1.5))) {
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity livingentity2 = (LivingEntity)e;
            if (e == pLivingEntity || e instanceof Player && ((Player)e).m_150110_().f_35934_) continue;
            Vec3 diff2 = livingentity2.m_20182_().m_82546_(vec32.m_82520_(0.0, 0.0, 0.0));
            diff2 = diff2.m_82541_().m_82490_(0.1);
            livingentity2.m_20256_(livingentity2.m_20184_().m_82546_(diff2));
            EntityUtil.applyPlayerDeltaMovement(livingentity2);
        }
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
    }

    public int cooldown() {
        return MathUtils.toSeconds(7.5f);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, -1);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pTarget.m_20254_(3);
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        int useDuration = this.m_8105_(pStack) - pTimeCharged;
        if ((float)useDuration >= this.maxChargeTick()) {
            Player player;
            pLivingEntity.m_5496_((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f);
            if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).m_36335_().m_41519_((Item)this)) {
                int uniformWarmup = -15;
                int lifeTick = 50;
                this.doPortalEffect(player, 7.5, 2.0f, 5, uniformWarmup, 2.0f, lifeTick, 8.0f);
                this.doPortalEffect(player, 4.0, 2.0f, 5, uniformWarmup, 2.0f, lifeTick, 8.0f);
                AnnihilationPortalEntity annihilationPortalEntity = new AnnihilationPortalEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, uniformWarmup, (LivingEntity)player, lifeTick, 12.5f, true, 4.0f);
                player.m_9236_().m_7967_((Entity)annihilationPortalEntity);
                Circle.RingData particleOptions = new Circle.RingData(0.0f, 1.5707964f, 20, 0.0f, 1.0f, 0.0f, 1.0f, 150.0f, false, Circle.EnumRingBehavior.SHRINK);
                if (player.m_9236_().f_46443_) {
                    player.m_9236_().m_7106_((ParticleOptions)particleOptions, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), 0.0, 0.0, 0.0);
                }
                player.m_36335_().m_41524_((Item)this, this.cooldown());
            }
        }
    }

    public void doPortalEffect(Player player, double multiplier, float size, int amountOfPortals, int warmup, float scale, int life, float damage) {
        for (int k = 0; k < amountOfPortals; ++k) {
            float f3 = (float)k * (float)Math.PI * size / (float)amountOfPortals + (float)Math.PI * size / 10.0f;
            this.createAnnihilationPortal(player, player.m_20185_() + (double)Mth.m_14089_((float)f3) * multiplier, player.m_20189_() + (double)Mth.m_14031_((float)f3) * multiplier, player.m_20186_() - 5.0, player.m_20186_() + 5.0, life, warmup, scale, damage);
        }
    }

    private void createAnnihilationPortal(Player player, double pX, double pZ, double pMinY, double pMaxY, int life, int pWarmupDelay, float scale, float damage) {
        BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pMaxY, (double)pZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = player.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)player.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!player.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = player.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)player.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
        if (flag) {
            player.m_9236_().m_7967_((Entity)new AnnihilationPortalEntity(player.m_9236_(), pX, (double)blockpos.m_123342_() + d0, pZ, 0.0f, pWarmupDelay, (LivingEntity)player, life, damage, true, scale));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.the_tesseract1"));
        list.add((Component)Component.m_237115_((String)"item.legendary_monsters.the_tesseract2"));
    }
}

