/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom.customArmor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.miauczel.legendary_monsters.item.custom.customArmor.client.model.ArmorModel;
import net.miauczel.legendary_monsters.item.custom.customArmor.client.model.provider.ArmorModelProvider;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractArmorItem
extends ArmorItem {
    public AbstractArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public boolean isFullSetActive(LivingEntity living) {
        return AbstractArmorItem.isFullSetActive(living, this.m_40401_());
    }

    public static boolean isFullSetActive(LivingEntity living, ArmorMaterial materials) {
        ArmorItem armorItem;
        ArmorItem armorItem2;
        ArmorItem armorItem3;
        if (living == null) {
            return false;
        }
        Item item = living.m_6844_(EquipmentSlot.HEAD).m_41720_();
        ArmorItem head = item instanceof ArmorItem ? (armorItem3 = (ArmorItem)item) : null;
        Item chestPlate = living.m_6844_(EquipmentSlot.CHEST).m_41720_();
        if (chestPlate instanceof ElytraItem || chestPlate instanceof AirItem) {
            return false;
        }
        ArmorItem chest = (ArmorItem)living.m_6844_(EquipmentSlot.CHEST).m_41720_();
        Item item2 = living.m_6844_(EquipmentSlot.LEGS).m_41720_();
        ArmorItem legs = item2 instanceof ArmorItem ? (armorItem2 = (ArmorItem)item2) : null;
        Item item3 = living.m_6844_(EquipmentSlot.FEET).m_41720_();
        ArmorItem feet = item3 instanceof ArmorItem ? (armorItem = (ArmorItem)item3) : null;
        return head != null && legs != null && feet != null && head.m_40401_() == materials && chest.m_40401_() == materials && legs.m_40401_() == materials && feet.m_40401_() == materials;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeMods(EquipmentSlot slot) {
        return null;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot slot) {
        HashMultimap builder = HashMultimap.create();
        builder.putAll(super.m_7167_(slot));
        if (this.getAttributeMods(slot) != null) {
            builder.putAll(this.getAttributeMods(slot));
        }
        return builder;
    }

    protected boolean withCustomModel() {
        return false;
    }

    protected ArmorModelProvider createModelProvider() {
        return null;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        if (!this.withCustomModel()) {
            return;
        }
        consumer.accept(new IClientItemExtensions(){
            private final ArmorModelProvider provider;
            {
                this.provider = AbstractArmorItem.this.createModelProvider();
            }

            @NotNull
            public ArmorModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                ArmorModel armorModel = this.provider.getModel(living, stack, slot);
                armorModel.partVisible(slot);
                armorModel.f_102817_ = original.f_102817_;
                armorModel.f_102609_ = original.f_102609_;
                armorModel.f_102610_ = original.f_102610_;
                return armorModel;
            }

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                HumanoidModel model = this.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, (HumanoidModel)original);
                this.copyModelProperties(original, (ArmorModel)model);
                return model;
            }

            private <T extends LivingEntity> void copyModelProperties(HumanoidModel<T> original, ArmorModel replacement) {
                original.m_102872_((HumanoidModel)replacement);
                replacement.rightBoot.m_104315_(original.f_102813_);
                replacement.leftBoot.m_104315_(original.f_102814_);
            }
        });
    }

    public static String makeCustomTextureLocation(String nameSpace, String id) {
        return new ResourceLocation(nameSpace, "textures/models/armor/custom/" + id + ".png").toString();
    }

    public static <T extends AbstractArmorItem> Map<ArmorItem.Type, RegistryObject<T>> createRegistry(DeferredRegister<Item> registry, String baseName, Function<ArmorItem.Type, T> creator) {
        return (Map)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                map.put(type, registry.register(baseName + "_" + type.m_266355_(), () -> (AbstractArmorItem)((Object)((Object)((Object)creator.apply(type))))));
            }
        });
    }
}

