/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.item.custom.customArmor.armorItem;

import java.util.List;
import net.miauczel.legendary_monsters.LegendaryMonsters;
import net.miauczel.legendary_monsters.Message.AnnihilatorHelmetAbilityMessage;
import net.miauczel.legendary_monsters.Particle.ModParticles;
import net.miauczel.legendary_monsters.Particle.custom.Circle;
import net.miauczel.legendary_monsters.damagetype.ModDamageTypes;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.item.custom.customArmor.AbstractArmorItem;
import net.miauczel.legendary_monsters.item.custom.customArmor.ModArmorMaterials;
import net.miauczel.legendary_monsters.item.custom.customArmor.client.model.AnnihilatorArmorModel;
import net.miauczel.legendary_monsters.item.custom.customArmor.client.model.provider.ArmorModelProvider;
import net.miauczel.legendary_monsters.item.custom.customArmor.client.model.provider.simpleModelProvider;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.util.BlockUtils;
import net.miauczel.legendary_monsters.util.MathUtils;
import net.miauczel.legendary_monsters.util.MessageArmorKey;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AnnihilatorArmorItem
extends AbstractArmorItem {
    private static final String LOCATION = AnnihilatorArmorItem.makeCustomTextureLocation("legendary_monsters", "annihilator");
    public boolean usedChestplate = false;
    public int chestplateTicks = -1;

    public AnnihilatorArmorItem(ArmorItem.Type pType) {
        super(ModArmorMaterials.ANNIHILATOR, pType, new Item.Properties().m_41497_(Rarity.EPIC));
    }

    public AnnihilatorArmorItem(ModArmorMaterials modArmorMaterials, ArmorItem.Type pType, Item.Properties rarity) {
        super(modArmorMaterials, pType, rarity);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (this.getPieceType("helmet")) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.legendary_monsters.annihilator_helmet1").m_130940_(ChatFormatting.GRAY));
        }
        if (this.getPieceType("chestplate")) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.legendary_monsters.annihilator_chestplate1").m_130940_(ChatFormatting.GRAY));
        }
        if (this.getPieceType("leggings")) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.legendary_monsters.annihilator_leggings1").m_130940_(ChatFormatting.GRAY));
        }
        if (this.getPieceType("boots")) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.legendary_monsters.annihilator_boots1").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean getPieceType(String piece) {
        switch (piece) {
            case "boots": {
                return this.m_40402_() == ArmorItem.Type.BOOTS.m_266308_() && this.m_266204_() == ArmorItem.Type.BOOTS;
            }
            case "helmet": {
                return this.m_40402_() == ArmorItem.Type.HELMET.m_266308_() && this.m_266204_() == ArmorItem.Type.HELMET;
            }
            case "chestplate": {
                return this.m_40402_() == ArmorItem.Type.CHESTPLATE.m_266308_() && this.m_266204_() == ArmorItem.Type.CHESTPLATE;
            }
            case "leggings": {
                return this.m_40402_() == ArmorItem.Type.LEGGINGS.m_266308_() && this.m_266204_() == ArmorItem.Type.LEGGINGS;
            }
        }
        return false;
    }

    public void onKeyPacket(Player player, ItemStack itemStack, int Type2) {
        if (this.getPieceType("helmet") && player != null && !player.m_36335_().m_41519_((Item)this)) {
            int UUID2 = player.m_20148_().hashCode();
            LegendaryMonsters.sendMSGToServer(new AnnihilatorHelmetAbilityMessage(0, UUID2, 0));
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (this.getPieceType("helmet") && pEntity instanceof Player) {
            Player living = (Player)pEntity;
            int type = 6;
            if (living.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModItems.ANNIHILATOR_HELMET.get() && pLevel.f_46443_ && LegendaryMonsters.PROXY.getClientSidePlayer() == pEntity && LegendaryMonsters.PROXY.isKeyDown(type)) {
                LegendaryMonsters.sendMSGToServer(new MessageArmorKey(EquipmentSlot.HEAD.ordinal(), living.m_19879_(), type));
                this.onKeyPacket(living, pStack, type);
            }
        }
        if (this.getPieceType("chestplate") && this.chestplateTicks >= 0 && this.chestplateTicks < 10) {
            ++this.chestplateTicks;
            this.Sphereparticle((ParticleOptions)ModParticles.SMALL_ANNIHILATION_FLAME.get(), 0.35f, 0.0f, 2.0f, (Player)pEntity);
        }
        if (this.getPieceType("chestplate") && pEntity instanceof Player) {
            boolean max;
            player = (Player)pEntity;
            Level level = pLevel;
            if (this.chestplateTicks >= 0 && this.chestplateTicks < 10) {
                this.Sphereparticle((ParticleOptions)ModParticles.SMALL_ANNIHILATION_FLAME.get(), 0.35f, 0.0f, 2.0f, player);
            }
            boolean bl = max = player.m_21223_() <= player.m_21233_() * 0.5f;
            if (max && !player.m_36335_().m_41519_((Item)this)) {
                player.m_36335_().m_41524_((Item)ModItems.ANNIHILATOR_CHESTPLATE.get(), MathUtils.toSeconds(20.0f));
                level.m_5594_(null, BlockUtils.blockPosVec3(player.m_20182_()), ModSounds.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                Circle.RingData particleOptions = new Circle.RingData(0.0f, 1.5707964f, 30, 0.0f, 1.0f, 0.0f, 1.0f, 100.0f, false, Circle.EnumRingBehavior.GROW);
                level.m_7106_((ParticleOptions)particleOptions, player.m_20185_(), player.m_20186_() + 0.25, player.m_20189_(), 0.0, 0.0, 0.0);
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.UNBREAKABLE.get(), MathUtils.toSeconds(4.0f), 0));
                AABB aabb = player.m_20191_().m_82400_(5.0);
                for (LivingEntity entity : level.m_45976_(LivingEntity.class, aabb)) {
                    TamableAnimal tamableAnimal;
                    if (entity == player || entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).m_21824_() && tamableAnimal.m_269323_() == player) continue;
                    entity.m_6469_(ModDamageTypes.causeAnnihilationDamage((Entity)player, (LivingEntity)player), 15.0f);
                    entity.m_20254_(3);
                }
                this.chestplateTicks = 0;
            }
        }
        if (this.getPieceType("boots") && pEntity instanceof Player) {
            player = (Player)pEntity;
            if (player.m_21023_(MobEffects.f_19613_)) {
                player.m_21195_(MobEffects.f_19613_);
            } else if (player.m_21023_(MobEffects.f_19597_)) {
                player.m_21195_(MobEffects.f_19597_);
            }
        }
    }

    private void Sphereparticle(ParticleOptions particleType, float height, float vec, float size, Player player) {
        if (player.m_9236_().f_46443_ && player.f_19797_ % 2 == 0) {
            double d0 = player.m_20185_();
            double d1 = player.m_20186_() + (double)height;
            double d2 = player.m_20189_();
            double theta = (double)player.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (player.m_217043_().m_188500_() - player.m_217043_().m_188500_()) * 0.5;
                        double d4 = (double)i + (player.m_217043_().m_188500_() - player.m_217043_().m_188500_()) * 0.5;
                        double d5 = (double)k + (player.m_217043_().m_188500_() - player.m_217043_().m_188500_()) * 0.5;
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + player.m_217043_().m_188583_() * 0.05;
                        player.m_9236_().m_7106_(particleType, d0 + (double)vec * vecX, d1, d2 + (double)vec * vecZ, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2.0f - 1.0f;
                    }
                }
            }
        }
    }

    protected BlockHitResult VoidBelow(Level pLevel, Player pPlayer, ClipContext.Fluid pFluidMode) {
        float f = pPlayer.m_146909_();
        float f1 = pPlayer.m_146908_();
        Vec3 vec3 = pPlayer.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d1 = Math.toRadians(f + 90.0f);
        double d0 = 10.0;
        Vec3 vec31 = vec3.m_82520_(d1 * d0, d1 * d0, d1 * d0);
        return pLevel.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, pFluidMode, (Entity)pPlayer));
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    @Override
    protected boolean withCustomModel() {
        return true;
    }

    @Override
    protected ArmorModelProvider createModelProvider() {
        return new simpleModelProvider(AnnihilatorArmorModel::createBodyLayer, AnnihilatorArmorModel::new);
    }

    @javax.annotation.Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return LOCATION;
    }
}

