/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.util;

import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class EntityUtil {
    public static final UUID HEALTH_MULT_UUID = UUID.fromString("9513569b-57b6-41f5-814e-bdc49b81799f");
    public static final UUID DAMAGE_MULT_UUID = UUID.fromString("22653B89-116E-49DC-9B6B-9971489B5BE5");

    public static void applyPlayerDeltaMovement(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity));
        }
    }

    public static void applyServerTeleport(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_143334_((Entity)entity);
        }
    }

    public static void applyHealthMultiplier(LivingEntity livingEntity, double healthMultiplier) {
        double amount;
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance maxHp = livingEntity.m_21051_(Attributes.f_22276_);
        if (maxHp == null) {
            return;
        }
        if (livingEntity.m_21223_() != livingEntity.m_21233_() || livingEntity.m_21223_() != livingEntity.m_21233_() && (double)livingEntity.m_21223_() != maxHp.m_22115_()) {
            return;
        }
        if (maxHp.m_22111_(HEALTH_MULT_UUID) != null) {
            maxHp.m_22120_(HEALTH_MULT_UUID);
        }
        if ((amount = healthMultiplier - 1.0) != 0.0) {
            AttributeModifier modifier = new AttributeModifier(HEALTH_MULT_UUID, "config_health_multiplier", amount, AttributeModifier.Operation.MULTIPLY_TOTAL);
            maxHp.m_22125_(modifier);
            livingEntity.m_21153_(livingEntity.m_21233_());
        }
        livingEntity.m_21153_(Math.min(livingEntity.m_21223_(), livingEntity.m_21233_()));
    }

    public static void applyStackingEffect(LivingEntity entity, MobEffect effect, int bonusLevel, int maxLevel, int duration) {
        MobEffectInstance effectInstance = entity.m_21124_(effect);
        if (entity.m_21023_(effect) && effectInstance != null) {
            int effectLevel = effectInstance.m_19564_();
            if (effectLevel < maxLevel) {
                entity.m_7292_(new MobEffectInstance(effect, duration, effectLevel + bonusLevel));
            }
        } else if (!entity.m_21023_(effect) || effectInstance == null) {
            entity.m_7292_(new MobEffectInstance(effect, duration, 0));
        }
    }
}

