/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class MathUtils {
    public static final float TAU = (float)Math.PI * 2;
    public static final float PI = (float)Math.PI;

    public static float entityBasedHpDamage(LivingEntity entity, float precentage) {
        return (float)((double)entity.m_21233_() * ((double)precentage * 0.01));
    }

    public static int toSeconds(float seconds) {
        return (int)(seconds * 20.0f);
    }

    public static float toPrecent(float precentage) {
        return (float)((double)precentage * 0.01);
    }

    public static Vec3 rotateYaw(Vec3 vec, double angleDeg) {
        double rad = Math.toRadians(angleDeg);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = vec.f_82479_ * cos - vec.f_82481_ * sin;
        double z = vec.f_82479_ * sin + vec.f_82481_ * cos;
        return new Vec3(x, vec.f_82480_, z);
    }

    public static float distanceToVec(Vec3 startPos, Vec3 endPos) {
        float f = (float)(startPos.f_82479_ - endPos.f_82479_);
        float f1 = (float)(startPos.f_82480_ - endPos.f_82480_);
        float f2 = (float)((double)((float)startPos.f_82481_) - endPos.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static double linearTransformd(double x, double domainMin, double domainMax, double rangeMin, double rangeMax) {
        x = x < domainMin ? domainMin : (x > domainMax ? domainMax : x);
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }

    public static double fit(double pct, double lbound, double hbound, double start, double end) {
        double npct = (pct - lbound) / (hbound - lbound);
        npct = Math.max(Math.min(1.0, npct), 0.0);
        return start + npct * (end - start);
    }

    public static Quaternionf quatFromRotationXYZ(float x, float y, float z, boolean degrees) {
        if (degrees) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        return new Quaternionf().rotationXYZ(x, y, z);
    }
}

