/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.worldgen.Structure.Custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.miauczel.legendary_monsters.worldgen.Structure.Custom.LMJigsawPlacement;
import net.miauczel.legendary_monsters.worldgen.Structure.ModStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class LMJigsawStructure
extends Structure {
    public static final int MAX_TOTAL_STRUCTURE_RANGE = 399;
    public static final Codec<LMJigsawStructure> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(p_227640_ -> p_227640_.group((App)LMJigsawStructure.m_226567_((RecordCodecBuilder.Instance)p_227640_), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(p_227656_ -> p_227656_.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(p_227654_ -> p_227654_.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(p_227652_ -> p_227652_.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(p_227649_ -> p_227649_.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(p_227646_ -> p_227646_.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(p_227644_ -> p_227644_.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)399).fieldOf("max_distance_from_center").forGetter(p_227642_ -> p_227642_.maxDistanceFromCenter)).apply((Applicative)p_227640_, LMJigsawStructure::new)), LMJigsawStructure::verifyRange).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static DataResult<LMJigsawStructure> verifyRange(LMJigsawStructure p_286886_) {
        int $$1 = switch (p_286886_.m_226620_()) {
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            default -> throw new IncompatibleClassChangeError();
        };
        return p_286886_.maxDistanceFromCenter + $$1 > 399 ? DataResult.error(() -> "LM Structure size including terrain adaptation must not exceed: 399") : DataResult.success((Object)((Object)p_286886_));
    }

    public LMJigsawStructure(Structure.StructureSettings p_227627_, Holder<StructureTemplatePool> p_227628_, Optional<ResourceLocation> p_227629_, int p_227630_, HeightProvider p_227631_, boolean p_227632_, Optional<Heightmap.Types> p_227633_, int p_227634_) {
        super(p_227627_);
        this.startPool = p_227628_;
        this.startJigsawName = p_227629_;
        this.maxDepth = p_227630_;
        this.startHeight = p_227631_;
        this.useExpansionHack = p_227632_;
        this.projectStartToHeightmap = p_227633_;
        this.maxDistanceFromCenter = p_227634_;
    }

    public LMJigsawStructure(Structure.StructureSettings pSettings, Holder<StructureTemplatePool> pStartPool, int pMaxDepth, HeightProvider pStartHeight, boolean pUseExpansionHack, Heightmap.Types pProjectStartToHeightmap) {
        this(pSettings, pStartPool, Optional.empty(), pMaxDepth, pStartHeight, pUseExpansionHack, Optional.of(pProjectStartToHeightmap), 399);
    }

    public LMJigsawStructure(Structure.StructureSettings pSettings, Holder<StructureTemplatePool> pStartPool, int pMaxDepth, HeightProvider pStartHeight, boolean pUseExpansionHack) {
        this(pSettings, pStartPool, Optional.empty(), pMaxDepth, pStartHeight, pUseExpansionHack, Optional.empty(), 399);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext pContext) {
        ChunkPos $$1 = pContext.f_226628_();
        int $$2 = this.startHeight.m_213859_((RandomSource)pContext.f_226626_(), new WorldGenerationContext(pContext.f_226622_(), pContext.f_226629_()));
        BlockPos $$3 = new BlockPos($$1.m_45604_(), $$2, $$1.m_45605_());
        return LMJigsawPlacement.addPieces(pContext, this.startPool, this.startJigsawName, this.maxDepth, $$3, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModStructures.LM_JIGSAW.get();
    }
}

