/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class InvalidCrops {
    private static final CachedSupplier<Block> potBlockType = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BotanyPotsMod.id("terracotta_hopper_botany_pot"));

    public static void build(LiteralArgumentBuilder<CommandSourceStack> parent) {
        LiteralArgumentBuilder cmd = Commands.literal((String)"check_crops");
        cmd.executes(InvalidCrops::execute);
        parent.then((ArgumentBuilder)cmd);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos targetPos = ((CommandSourceStack)ctx.getSource()).getEntityOrException().getOnPos();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        level.setBlock(targetPos, ((Block)potBlockType.get()).defaultBlockState(), 3);
        BotanyPotBlockEntity potEntity = (BotanyPotBlockEntity)level.getBlockEntity(targetPos);
        if (potEntity == null) {
            throw new IllegalStateException("Test pot was null!");
        }
        Set crops = Objects.requireNonNull((RecipeCache)Crop.CACHE.apply((Level)((CommandSourceStack)ctx.getSource()).getLevel())).getCachedValues().entries().stream().sorted(Comparator.comparing(s -> BuiltInRegistries.ITEM.getKey((Object)((Item)s.getKey())).toString())).collect(Collectors.toCollection(LinkedHashSet::new));
        List<ItemStack> toolList = InvalidCrops.buildToolList(((CommandSourceStack)ctx.getSource()).registryAccess());
        int errorCount = 0;
        block0: for (Map.Entry cropEntry : crops) {
            Crop crop = (Crop)((RecipeHolder)cropEntry.getValue()).value();
            potEntity.clearContent();
            ItemStack firstSoil = InvalidCrops.findFirstSoil(crop);
            if (firstSoil.isEmpty()) {
                BotanyPotsMod.LOG.error("Could not find a valid soil for crop '{}'!", (Object)((RecipeHolder)cropEntry.getValue()).id());
                ++errorCount;
                continue;
            }
            potEntity.setItem(0, InvalidCrops.findFirstSoil(crop));
            potEntity.setItem(1, ((Item)cropEntry.getKey()).getDefaultInstance());
            for (ItemStack tool : toolList) {
                potEntity.setItem(2, tool.copy());
                ArrayList items = new ArrayList();
                for (int i = 0; i < 1000; ++i) {
                    potEntity.updateGrowthTime(potEntity.getRequiredGrowthTicks());
                    crop.onHarvest(potEntity.getRecipeContext(), (Level)level, items::add);
                    if (!items.isEmpty()) continue block0;
                }
            }
            ++errorCount;
            BotanyPotsMod.LOG.error("Crop '{}' did not drop any items!", (Object)((RecipeHolder)cropEntry.getValue()).id());
        }
        if (errorCount > 0) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"commands.botanypots.debug.crop_errors", (Object[])new Object[]{crops.size(), errorCount}));
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.botanypots.debug.crop_success", (Object[])new Object[]{crops.size()}), false);
        }
        return errorCount;
    }

    private static ItemStack findFirstSoil(Crop crop) {
        if (crop instanceof BasicCrop) {
            BasicCrop basic = (BasicCrop)crop;
            for (Item item : BuiltInRegistries.ITEM) {
                ItemStack stack = item.getDefaultInstance();
                if (!basic.getBasicProperties().soil().test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    private static List<ItemStack> buildToolList(RegistryAccess registries) {
        ArrayList<ItemStack> tools = new ArrayList<ItemStack>();
        tools.add(ItemStack.EMPTY);
        tools.add(InvalidCrops.withSilkTouch(Items.SHEARS, registries));
        tools.add(InvalidCrops.withSilkTouch(Items.NETHERITE_HOE, registries));
        tools.add(InvalidCrops.withSilkTouch(Items.NETHERITE_PICKAXE, registries));
        tools.add(InvalidCrops.withSilkTouch(Items.NETHERITE_AXE, registries));
        tools.add(InvalidCrops.withSilkTouch(Items.NETHERITE_SWORD, registries));
        tools.add(InvalidCrops.withSilkTouch(Items.NETHERITE_SHOVEL, registries));
        return tools;
    }

    private static ItemStack withSilkTouch(Item item, RegistryAccess registries) {
        ItemStack stack = item.getDefaultInstance();
        stack.enchant((Holder)registries.registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SILK_TOUCH).orElseThrow(), 1);
        return stack;
    }
}

