/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.interaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.SoundEffect;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class BasicPotInteraction
extends PotInteraction
implements CacheableRecipe {
    public static final MapCodec<BasicPotInteraction> CODEC = Properties.CODEC.xmap(BasicPotInteraction::new, BasicPotInteraction::getProperties);
    public static final StreamCodec<RegistryFriendlyByteBuf, BasicPotInteraction> STREAM = Properties.STREAM.map(BasicPotInteraction::new, BasicPotInteraction::getProperties);
    public static final RecipeSerializer<BasicPotInteraction> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    public final Properties properties;

    public BasicPotInteraction(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void apply(@NotNull BotanyPotContext context) {
        ServerPlayer player;
        BlockEntityContext input;
        Player player2;
        if (context instanceof BlockEntityContext && (player2 = (input = (BlockEntityContext)context).player()) instanceof ServerPlayer && (player2 = (player = (ServerPlayer)player2).level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)player2;
            this.properties.newSoil.ifPresent(soilStack -> {
                Services.GAMEPLAY.dropRemainders((Level)level, input.pot().getBlockPos(), input.getSoilItem());
                input.pot().setSoilItem(soilStack.copy());
            });
            this.properties.newSeed.ifPresent(seedStack -> {
                Services.GAMEPLAY.dropRemainders((Level)level, input.pot().getBlockPos(), input.getSoilItem());
                input.pot().setSeed(seedStack.copy());
            });
            ItemStack usedItem = input.getInteractionItem();
            if (!usedItem.isEmpty()) {
                if (this.properties.damageHeld) {
                    usedItem.hurtAndBreak(1, (LivingEntity)player, input.hand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                } else if (this.properties.consumeHeld) {
                    Services.GAMEPLAY.dropRemainders((Level)level, input.pot().getBlockPos(), usedItem.split(1));
                }
            }
            this.properties.extraDrops.ifPresent(tableKey -> {
                LootTable table = level.getServer().reloadableRegistries().getLootTable(tableKey);
                BlockPos pos = input.pot().getBlockPos();
                if (table != LootTable.EMPTY) {
                    table.getRandomItems(input.createLootParams(null)).forEach(drop -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop));
                }
            });
            this.properties.soundEffect.ifPresent(soundEffect -> soundEffect.playSound(level, null, input.pot().getBlockPos()));
            if (this.properties.notifySculk) {
                level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, input.pot().getBlockPos());
            }
        }
    }

    public boolean matches(@NotNull BotanyPotContext input, @NotNull Level level) {
        return this.properties.validateInputs(input.getInteractionItem(), input.getSoilItem(), input.getSeedItem());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public boolean couldMatch(ItemStack candidate, BotanyPotContext context, Level level) {
        return this.properties.validateInputs(candidate, context.getSoilItem(), context.getSeedItem());
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(ItemStack stack) {
        return this.properties.heldTest.test(stack);
    }

    public record Properties(Ingredient heldTest, boolean damageHeld, boolean consumeHeld, Optional<Ingredient> soilTest, Optional<Ingredient> seedTest, Optional<ItemStack> newSoil, Optional<ItemStack> newSeed, Optional<ResourceKey<LootTable>> extraDrops, Optional<SoundEffect> soundEffect, boolean notifySculk) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("held_item").forGetter(Properties::heldTest), (App)Codec.BOOL.optionalFieldOf("damage_held", (Object)true).forGetter(Properties::damageHeld), (App)Codec.BOOL.optionalFieldOf("consume_held", (Object)false).forGetter(Properties::consumeHeld), (App)Ingredient.CODEC.optionalFieldOf("soil_item").forGetter(Properties::soilTest), (App)Ingredient.CODEC.optionalFieldOf("seed_item").forGetter(Properties::seedTest), (App)ItemStack.CODEC.optionalFieldOf("new_soil").forGetter(Properties::newSoil), (App)ItemStack.CODEC.optionalFieldOf("new_seed").forGetter(Properties::newSeed), (App)ResourceLocation.CODEC.optionalFieldOf("extra_drops").xmap(rl -> rl.map(arl -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)arl)), arl -> arl.map(ResourceKey::location)).forGetter(Properties::extraDrops), (App)SoundEffect.CODEC.codec().optionalFieldOf("sound_effect").forGetter(Properties::soundEffect), (App)Codec.BOOL.optionalFieldOf("notify_sculk", (Object)true).forGetter(Properties::notifySculk)).apply((Applicative)instance, Properties::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Properties> STREAM = new StreamCodec<RegistryFriendlyByteBuf, Properties>(){

            @NotNull
            public Properties decode(@NotNull RegistryFriendlyByteBuf buf) {
                Ingredient ingredient = (Ingredient)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                boolean damageHeld = buf.readBoolean();
                boolean consumeHeld = buf.readBoolean();
                Optional soilTest = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                Optional seedTest = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                Optional newSoil = (Optional)Helpers.OPTIONAL_ITEMSTACK_STREAM.decode((Object)buf);
                Optional newSeed = (Optional)Helpers.OPTIONAL_ITEMSTACK_STREAM.decode((Object)buf);
                Optional<ResourceKey<LootTable>> extraDrops = buf.readOptional((StreamDecoder)ResourceLocation.STREAM_CODEC).map(rl -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)rl));
                Optional soundEffect = (Optional)SoundEffect.OPTIONAL_STREAM.decode((Object)buf);
                boolean notifySculk = buf.readBoolean();
                return new Properties(ingredient, damageHeld, consumeHeld, soilTest, seedTest, newSoil, newSeed, extraDrops, soundEffect, notifySculk);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.heldTest);
                buf.writeBoolean(properties.damageHeld);
                buf.writeBoolean(properties.consumeHeld);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.soilTest);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.seedTest);
                Helpers.OPTIONAL_ITEMSTACK_STREAM.encode((Object)buf, properties.newSoil);
                Helpers.OPTIONAL_ITEMSTACK_STREAM.encode((Object)buf, properties.newSeed);
                buf.writeOptional(properties.extraDrops, (b, v) -> b.writeResourceLocation(v.location()));
                SoundEffect.OPTIONAL_STREAM.encode((Object)buf, properties.soundEffect);
                buf.writeBoolean(properties.notifySculk);
            }
        };

        public boolean validateInputs(ItemStack held, ItemStack soil, ItemStack seed) {
            return !(!this.heldTest.test(held) || !this.soilTest.isEmpty() && !this.soilTest.get().test(soil) || !this.seedTest.isEmpty() && !this.seedTest.get().test(seed));
        }
    }
}

