/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.itemdrops;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record ItemDropProviderType<T extends ItemDropProvider>(class_2960 typeID, MapCodec<T> codec, class_9139<class_9129, T> stream) {
    private static final Map<class_2960, ItemDropProviderType<?>> REGISTRY = new HashMap();
    public static final Codec<ItemDropProviderType<?>> TYPE_CODEC = class_2960.field_25139.xmap(REGISTRY::get, ItemDropProviderType::typeID);
    public static final class_9139<ByteBuf, ? extends ItemDropProviderType<?>> TYPE_STREAM = class_2960.field_48267.method_56432(REGISTRY::get, ItemDropProviderType::typeID);
    public static final Codec<ItemDropProvider> DROP_PROVIDER_CODEC = TYPE_CODEC.dispatch(ItemDropProvider::getType, ItemDropProviderType::codec);
    public static final class_9139<class_9129, ItemDropProvider> DROP_PROVIDER_STREAM = new class_9139<class_9129, ItemDropProvider>(){

        public void encode(@NotNull class_9129 buf, @NotNull ItemDropProvider dropProvider) {
            buf.method_10812(dropProvider.getType().typeID());
            dropProvider.getType().stream.encode((Object)buf, (Object)dropProvider);
        }

        @NotNull
        public ItemDropProvider decode(@NotNull class_9129 buf) {
            class_2960 id = buf.method_10810();
            if (!REGISTRY.containsKey(id)) {
                BotanyPotsMod.LOG.error("Drop provider {} does not exist!", (Object)id);
                throw new IllegalStateException("Drop provider " + String.valueOf(id) + " does not exist.");
            }
            return (ItemDropProvider)ItemDropProviderType.REGISTRY.get((Object)id).stream.decode((Object)buf);
        }
    };
    public static final Codec<List<ItemDropProvider>> LIST_CODEC = MapCodecs.flexibleList(DROP_PROVIDER_CODEC);

    public static Supplier<ItemDropProviderType<?>> getLazy(class_2960 id) {
        return CachedSupplier.cache(() -> ItemDropProviderType.get(id));
    }

    public static ItemDropProviderType<?> get(class_2960 id) {
        return REGISTRY.get(id);
    }

    public static <T extends ItemDropProvider> ItemDropProviderType<T> register(class_2960 id, MapCodec<T> codec, class_9139<class_9129, T> stream) {
        ItemDropProviderType<T> type = new ItemDropProviderType<T>(id, codec, stream);
        if (REGISTRY.containsKey(id)) {
            BotanyPotsMod.LOG.warn("Item drop provider {} has already been assigned to {}. Replacing it with {}.", new Object[]{id, REGISTRY.get(id), type});
        }
        REGISTRY.put(id, type);
        return type;
    }
}

