/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.crop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3544;
import net.minecraft.class_4550;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import org.jetbrains.annotations.NotNull;

public class BasicCrop
extends Crop
implements CacheableRecipe {
    public static final class_1856 DIRT = class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)BotanyPotsMod.id("soil/dirt")));
    public static final MapCodec<BasicCrop> CODEC = Properties.CODEC.xmap(BasicCrop::new, BasicCrop::getBasicProperties);
    public static final class_9139<class_9129, BasicCrop> STREAM = Properties.STREAM.method_56432(BasicCrop::new, BasicCrop::getBasicProperties);
    public static final class_1865<BasicCrop> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    private final Properties properties;

    public BasicCrop(Properties properties) {
        this.properties = properties;
    }

    public Properties getBasicProperties() {
        return this.properties;
    }

    public boolean matches(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        if (input instanceof BlockEntityContext) {
            BlockEntityContext context = (BlockEntityContext)input;
            if (this.properties.potPredicate.isPresent() && !this.properties.potPredicate.get().method_57147(context.blockInWorld())) {
                return false;
            }
        }
        return this.properties.input.method_8093(input.getSeedItem());
    }

    @Override
    public boolean couldMatch(class_1799 candidate, BotanyPotContext context, class_1937 level) {
        return this.properties.input.method_8093(candidate);
    }

    @Override
    public void onHarvest(BotanyPotContext context, class_1937 level, Consumer<class_1799> drops) {
        for (ItemDropProvider provider : this.properties.drops) {
            provider.apply(context, level, drops);
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.properties.functionId.ifPresent(context::runFunction);
        }
    }

    @Override
    public List<Display> getDisplayState(BotanyPotContext context, class_1937 level) {
        return this.properties.display;
    }

    @Override
    public int getRequiredGrowthTicks(BotanyPotContext context, class_1937 level) {
        return this.properties.growTime;
    }

    @Override
    public boolean isGrowthSustained(BotanyPotContext context, class_1937 level) {
        return this.properties.soil.method_8093(context.getSoilItem());
    }

    @Override
    public float getBaseYield(BotanyPotContext context, class_1937 level) {
        return this.properties.baseYield;
    }

    @Override
    public float getYieldScale(BotanyPotContext context, class_1937 level) {
        return this.properties.yieldScale;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(class_1799 stack) {
        return this.properties.input.method_8093(stack);
    }

    @NotNull
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @Override
    public void hoverTooltip(class_1799 stack, BotanyPotContext context, class_1937 level, Consumer<class_2561> tooltipLines) {
        if (stack == context.method_59984(1)) {
            float effectiveYield;
            if (this.isGrowthSustained(context, level)) {
                tooltipLines.accept((class_2561)class_2561.method_43469((String)"tooltip.botanypots.growth_time", (Object[])new Object[]{class_3544.method_15439((int)context.getRequiredGrowthTicks(), (float)level.method_54719().method_54748())}).method_27692(class_124.field_1080));
            }
            if ((effectiveYield = Helpers.getTotalYield(context, level, this, context.getSoil())) != 1.0f) {
                float yieldScale = this.getYieldScale(context, level);
                tooltipLines.accept((class_2561)class_2561.method_43469((String)"tooltip.botanypots.yield.total", (Object[])new Object[]{Helpers.chanceToInt(effectiveYield)}).method_27692(class_124.field_1080));
                float baseYield = this.getBaseYield(context, level);
                if (effectiveYield != baseYield) {
                    float toolYield;
                    BotanyPotBlock potBlock;
                    float potYield;
                    BlockEntityContext beContext;
                    class_2248 class_22482;
                    float soilYield;
                    tooltipLines.accept(Helpers.indent((class_2561)class_2561.method_43469((String)"tooltip.botanypots.yield.source.base", (Object[])new Object[]{Helpers.chanceToInt(this.getBaseYield(context, level))}).method_27692(class_124.field_1063)));
                    float f = soilYield = context.getSoil() != null ? context.getSoil().getYieldModifier(context, level) : 0.0f;
                    if (soilYield != 0.0f) {
                        tooltipLines.accept(Helpers.indent((class_2561)Helpers.withScale(class_2561.method_43469((String)"tooltip.botanypots.yield.source.soil", (Object[])new Object[]{Helpers.chanceToInt(soilYield)}), yieldScale).method_27692(class_124.field_1063)));
                    }
                    if (context instanceof BlockEntityContext && (class_22482 = (beContext = (BlockEntityContext)context).pot().method_11010().method_26204()) instanceof BotanyPotBlock && (potYield = (potBlock = (BotanyPotBlock)class_22482).getYieldModifier(context, level, this, context.getSoil())) != 0.0f) {
                        tooltipLines.accept(Helpers.indent((class_2561)Helpers.withScale(class_2561.method_43469((String)"tooltip.botanypots.yield.source.pot", (Object[])new Object[]{Helpers.chanceToInt(potYield)}), yieldScale).method_27692(class_124.field_1063)));
                    }
                    if ((toolYield = (float)Helpers.getAttributeValue(Helpers.YIELD_MOD_ATTRIBUTE.get(), context.getHarvestItem(), 0.0f)) != 0.0f) {
                        tooltipLines.accept(Helpers.indent((class_2561)Helpers.withScale(class_2561.method_43469((String)"tooltip.botanypots.yield.source.tool", (Object[])new Object[]{Helpers.chanceToInt(toolYield)}), yieldScale).method_27692(class_124.field_1063)));
                    }
                }
            }
            if (!this.properties.soil.method_8093(context.method_59984(0))) {
                tooltipLines.accept((class_2561)class_2561.method_43469((String)"tooltip.botanypots.wrong_soil", (Object[])new Object[]{context.getSoilItem().method_7964()}).method_27692(class_124.field_1061));
            }
            if (context instanceof BlockEntityContext) {
                BlockEntityContext beContext = (BlockEntityContext)context;
                if (this.properties.potPredicate.isPresent() && !this.properties.potPredicate.get().method_57147(beContext.blockInWorld())) {
                    tooltipLines.accept((class_2561)class_2561.method_43469((String)"tooltip.botanypots.wrong_pot", (Object[])new Object[]{beContext.pot().method_11010().method_26204().method_9518()}).method_27692(class_124.field_1061));
                }
            }
        } else {
            float dropScale;
            tooltipLines.accept((class_2561)class_2561.method_43469((String)"tooltip.botanypots.growth_time", (Object[])new Object[]{class_3544.method_15439((int)this.properties.growTime, (float)level.method_54719().method_54748())}).method_27692(class_124.field_1080));
            float dropChance = this.getBaseYield(context, level);
            if (dropChance != 1.0f) {
                tooltipLines.accept((class_2561)class_2561.method_43469((String)"tooltip.botanypots.yield.total", (Object[])new Object[]{Helpers.chanceToInt(dropChance)}).method_27692(class_124.field_1080));
            }
            if ((dropScale = this.getYieldScale(context, level)) != 1.0f) {
                tooltipLines.accept((class_2561)class_2561.method_43469((String)"tooltip.botanypots.yield.scale", (Object[])new Object[]{Helpers.chanceToInt(dropScale)}).method_27692(class_124.field_1080));
            }
        }
    }

    public boolean isValidSoil(class_1799 stack) {
        return this.properties.soil.method_8093(stack);
    }

    public record Properties(class_1856 input, class_1856 soil, int growTime, List<Display> display, int lightLevel, List<ItemDropProvider> drops, Optional<class_2960> functionId, Optional<class_4550> potPredicate, float baseYield, float yieldScale) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("input").forGetter(Properties::input), (App)class_1856.field_46095.optionalFieldOf("soil", (Object)DIRT).forGetter(Properties::soil), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("grow_time", (Object)1200).forGetter(Properties::growTime), (App)DisplayType.LIST_CODEC.fieldOf("display").forGetter(Properties::display), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(Properties::lightLevel), (App)MapCodecs.flexibleList(ItemDropProviderType.DROP_PROVIDER_CODEC).optionalFieldOf("drops", List.of()).forGetter(Properties::drops), (App)class_2960.field_25139.optionalFieldOf("function").forGetter(Properties::functionId), (App)class_4550.field_45723.optionalFieldOf("pot_predicate").forGetter(Properties::potPredicate), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("yield", (Object)Float.valueOf(1.0f)).forGetter(Properties::baseYield), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("yield_scale", (Object)Float.valueOf(1.0f)).forGetter(Properties::yieldScale)).apply((Applicative)instance, Properties::new));
        public static final class_9139<class_9129, Properties> STREAM = new class_9139<class_9129, Properties>(){

            @NotNull
            public Properties decode(@NotNull class_9129 buf) {
                class_1856 input = (class_1856)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                class_1856 soil = (class_1856)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                int growTime = (Integer)class_9135.field_49675.decode((Object)buf);
                List display = buf.method_34066(DisplayType.DISPLAY_STATE_STREAM);
                int light = (Integer)class_9135.field_49675.decode((Object)buf);
                Optional functionId = buf.method_37436((class_9141)class_2960.field_48267);
                int dropSize = buf.readInt();
                LinkedList<ItemDropProvider> drops = new LinkedList<ItemDropProvider>();
                for (int i = 0; i < dropSize; ++i) {
                    drops.add((ItemDropProvider)ItemDropProviderType.DROP_PROVIDER_STREAM.decode((Object)buf));
                }
                Optional potPredicate = (Optional)Helpers.OPTIONAL_BLOCK_PREDICATE.decode((Object)buf);
                float baseYield = buf.readFloat();
                float yieldModifier = buf.readFloat();
                return new Properties(input, soil, growTime, display, light, drops, functionId, potPredicate, baseYield, yieldModifier);
            }

            public void encode(@NotNull class_9129 buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.input);
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.soil);
                class_9135.field_49675.encode((Object)buf, (Object)properties.growTime);
                buf.method_34062(properties.display, DisplayType.DISPLAY_STATE_STREAM);
                class_9135.field_49675.encode((Object)buf, (Object)properties.lightLevel);
                buf.method_37435(properties.functionId, (class_9142)class_2960.field_48267);
                buf.method_53002(properties.drops.size());
                for (ItemDropProvider provider : properties.drops) {
                    ItemDropProviderType.DROP_PROVIDER_STREAM.encode((Object)buf, (Object)provider);
                }
                Helpers.OPTIONAL_BLOCK_PREDICATE.encode((Object)buf, properties.potPredicate);
                buf.method_52941(properties.baseYield);
                buf.method_52941(properties.yieldScale);
            }
        };
    }
}

