/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.darkhax.botanypots.events.BotanyPotEventDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BotanyPotHelper {
    public static final CachedSupplier<RecipeType<Soil>> SOIL_TYPE = RegistryObject.deferred((Registry)BuiltInRegistries.f_256990_, (String)"botanypots", (String)"soil").cast();
    public static final CachedSupplier<RecipeSerializer<?>> SOIL_SERIALIZER = RegistryObject.deferred((Registry)BuiltInRegistries.f_256769_, (String)"botanypots", (String)"soil").cast();
    public static final CachedSupplier<RecipeType<Crop>> CROP_TYPE = RegistryObject.deferred((Registry)BuiltInRegistries.f_256990_, (String)"botanypots", (String)"crop").cast();
    public static final CachedSupplier<RecipeSerializer<?>> CROP_SERIALIZER = RegistryObject.deferred((Registry)BuiltInRegistries.f_256769_, (String)"botanypots", (String)"crop").cast();
    public static final CachedSupplier<RecipeType<PotInteraction>> POT_INTERACTION_TYPE = RegistryObject.deferred((Registry)BuiltInRegistries.f_256990_, (String)"botanypots", (String)"pot_interaction").cast();
    public static final CachedSupplier<RecipeSerializer<?>> SIMPLE_POT_INTERACTION_SERIALIZER = RegistryObject.deferred((Registry)BuiltInRegistries.f_256769_, (String)"botanypots", (String)"pot_interaction").cast();
    public static final CachedSupplier<RecipeType<Fertilizer>> FERTILIZER_TYPE = RegistryObject.deferred((Registry)BuiltInRegistries.f_256990_, (String)"botanypots", (String)"fertilizer").cast();
    public static final CachedSupplier<RecipeSerializer<?>> BASIC_FERTILIZER_SERIALIZER = RegistryObject.deferred((Registry)BuiltInRegistries.f_256769_, (String)"botanypots", (String)"fertilizer").cast();
    public static final BotanyPotEventDispatcher EVENT_DISPATCHER = (BotanyPotEventDispatcher)Services.load(BotanyPotEventDispatcher.class);

    public static int getRequiredGrowthTicks(Level level, BlockPos pos, BlockEntityBotanyPot pot, @Nullable RecipeHolder<Crop> crop, @Nullable RecipeHolder<Soil> soil) {
        if (crop == null || soil == null) {
            return -1;
        }
        return BotanyPotHelper.getRequiredGrowthTicks(level, pos, pot, (Crop)crop.f_291008_(), (Soil)soil.f_291008_());
    }

    public static int getRequiredGrowthTicks(Level level, BlockPos pos, BlockEntityBotanyPot pot, @Nullable Crop crop, @Nullable Soil soil) {
        if (crop == null || soil == null) {
            return -1;
        }
        float requiredGrowthTicks = crop.getGrowthTicks(level, pos, pot, soil);
        float growthModifier = soil.getGrowthModifier(level, pos, pot, crop);
        if (growthModifier >= 0.0f) {
            return Mth.m_14143_((float)(requiredGrowthTicks / growthModifier));
        }
        return -1;
    }

    public static boolean canCropGrow(Level level, BlockPos pos, BlockEntityBotanyPot pot, RecipeHolder<Soil> soil, RecipeHolder<Crop> crop) {
        return soil != null && crop != null && BotanyPotHelper.canCropGrow(level, pos, pot, (Soil)soil.f_291008_(), (Crop)crop.f_291008_());
    }

    public static boolean canCropGrow(Level level, BlockPos pos, BlockEntityBotanyPot pot, RecipeHolder<Soil> soil, Crop crop) {
        return soil != null && BotanyPotHelper.canCropGrow(level, pos, pot, (Soil)soil.f_291008_(), crop);
    }

    public static boolean canCropGrow(Level level, BlockPos pos, BlockEntityBotanyPot pot, Soil soil, Crop crop) {
        if (soil == null || crop == null) {
            return false;
        }
        return soil.canGrowCrop(level, pos, pot, crop) && crop.canGrowInSoil(level, pos, pot, soil);
    }

    @Nullable
    public static RecipeHolder<Soil> findSoil(Level level, BlockPos pos, BlockEntityBotanyPot pot, ItemStack soilStack) {
        RecipeHolder result = null;
        if (level != null && !soilStack.m_41619_()) {
            for (RecipeHolder recipe : BotanyPotHelper.getAllRecipes(level.m_7465_(), (RecipeType)SOIL_TYPE.get())) {
                if (!((Soil)recipe.f_291008_()).matchesLookup(level, pos, pot, soilStack)) continue;
                result = recipe;
                break;
            }
        }
        return EVENT_DISPATCHER.postSoilLookup(level, pos, pot, soilStack, result);
    }

    @Nullable
    public static RecipeHolder<Crop> findCrop(Level level, BlockPos pos, BlockEntityBotanyPot pot, ItemStack stack) {
        RecipeHolder result = null;
        if (level != null && !stack.m_41619_()) {
            for (RecipeHolder recipe : BotanyPotHelper.getAllRecipes(level.m_7465_(), (RecipeType)CROP_TYPE.get())) {
                if (!((Crop)recipe.f_291008_()).matchesLookup(level, pos, pot, stack)) continue;
                result = recipe;
                break;
            }
        }
        return EVENT_DISPATCHER.postCropLookup(level, pos, pot, stack, result);
    }

    public static <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> getAllRecipes(RecipeManager manager, RecipeType<T> type) {
        return manager.m_44013_(type);
    }

    @Nullable
    public static RecipeHolder<PotInteraction> findPotInteraction(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        RecipeHolder result = null;
        if (!heldStack.m_41619_()) {
            for (RecipeHolder recipe : BotanyPotHelper.getAllRecipes(world.m_7465_(), (RecipeType)POT_INTERACTION_TYPE.get())) {
                if (!((PotInteraction)recipe.f_291008_()).canApply(state, world, pos, player, hand, heldStack, pot)) continue;
                result = recipe;
                break;
            }
        }
        return EVENT_DISPATCHER.postInteractionLookup(state, world, pos, player, hand, heldStack, pot, result);
    }

    @Nullable
    public static RecipeHolder<Fertilizer> findFertilizer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        RecipeHolder result = null;
        if (!heldStack.m_41619_()) {
            for (RecipeHolder recipe : BotanyPotHelper.getAllRecipes(world.m_7465_(), (RecipeType)FERTILIZER_TYPE.get())) {
                if (!((Fertilizer)recipe.f_291008_()).canApply(state, world, pos, player, hand, heldStack, pot)) continue;
                result = recipe;
                break;
            }
        }
        return EVENT_DISPATCHER.postFertilizerLookup(state, world, pos, player, hand, heldStack, pot, result);
    }

    public static List<ItemStack> generateDrop(Random rng, Level level, BlockPos pos, BlockEntityBotanyPot pot, Crop crop) {
        return EVENT_DISPATCHER.postCropDrops(rng, level, pos, pot, crop, crop.generateDrops(rng, level, pos, pot));
    }
}

