/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import com.mojang.blaze3d.vertex.PoseStack;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.data.displaystate.math.AxisAlignedRotation;
import net.darkhax.botanypots.data.displaystate.render.DisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BotanyPotRenderer
implements BlockEntityRenderer<BlockEntityBotanyPot> {
    private final BlockEntityRendererProvider.Context renderContext;

    public BotanyPotRenderer(BlockEntityRendererProvider.Context ctx) {
        this.renderContext = ctx;
    }

    private static AxisAlignedRotation rotateFacing(Direction facing) {
        if (facing == Direction.EAST) {
            return AxisAlignedRotation.Y_90;
        }
        if (facing == Direction.NORTH) {
            return AxisAlignedRotation.Y_180;
        }
        if (facing == Direction.WEST) {
            return AxisAlignedRotation.Y_270;
        }
        return null;
    }

    public static void applyRotation(AxisAlignedRotation rotation, PoseStack pose) {
        pose.m_252781_(rotation.rotation);
        pose.m_252880_(rotation.offset.x(), rotation.offset.y(), rotation.offset.z());
    }

    public void render(BlockEntityBotanyPot pot, float tickDelta, PoseStack pose, MultiBufferSource bufferSource, int light, int overlay) {
        if (pot.getSoil() != null) {
            Level level = pot.m_58904_();
            BlockPos pos = pot.m_58899_();
            int maxGrowth = ((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
            float partialOffset = pot.getGrowthTime() < maxGrowth ? tickDelta : 0.0f;
            float growthProgress = Math.max(((float)pot.getGrowthTime() + partialOffset) / (float)maxGrowth, 0.0f);
            AxisAlignedRotation potRotation = BotanyPotRenderer.rotateFacing((Direction)pot.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
            pose.m_85836_();
            if (potRotation != null) {
                BotanyPotRenderer.applyRotation(potRotation, pose);
            }
            pose.m_85841_(0.625f, 0.375f, 0.625f);
            pose.m_85837_(0.3, 0.0625, 0.3);
            DisplayStateRenderer.renderState(this.renderContext, pot.getSoil().getDisplayState(level, pos, pot), pose, level, pos, partialOffset, bufferSource, light, overlay, pot, growthProgress);
            pose.m_85849_();
            if (pot.getCrop() != null && BotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), pot.getCrop())) {
                pose.m_85836_();
                if (potRotation != null) {
                    BotanyPotRenderer.applyRotation(potRotation, pose);
                }
                pose.m_85837_(0.5, 0.40625, 0.5);
                float cropScale = Mth.m_14036_((float)((0.4f + growthProgress * 0.6f) * 0.625f), (float)0.15625f, (float)0.625f);
                pose.m_85841_(cropScale, cropScale, cropScale);
                pose.m_85837_(-0.5, 0.0, -0.5);
                int previousBlocks = 0;
                for (DisplayState state : pot.getCrop().getDisplayState(level, pos, pot)) {
                    if (previousBlocks > 0) {
                        pose.m_252880_(0.0f, 1.0f, 0.0f);
                    }
                    pose.m_85836_();
                    DisplayStateRenderer.renderState(this.renderContext, state, pose, pot.m_58904_(), pot.m_58899_(), partialOffset, bufferSource, light, overlay, pot, growthProgress);
                    pose.m_85849_();
                    ++previousBlocks;
                }
                pose.m_85849_();
            }
        }
    }
}

