/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotMenu;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class BotanyPotScreen
extends AbstractContainerScreen<BotanyPotMenu> {
    private static final NumberFormat MULTIPLIER_FORMAT = new DecimalFormat("##.##");
    private static final Component NEW_LINE = Component.m_237113_((String)"");
    private static final Component TOOLTIP_INVALID_SOIL = Component.m_237115_((String)"tooltip.botanypots.invalid_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INVALID_CROP = Component.m_237115_((String)"tooltip.botanypots.invalid_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SOIL = Component.m_237115_((String)"tooltip.botanypots.incorrect_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SEED = Component.m_237115_((String)"tooltip.botanypots.incorrect_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SOIL = Component.m_237115_((String)"tooltip.botanypots.missing_soil").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SEED = Component.m_237115_((String)"tooltip.botanypots.missing_seed").m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_SOIL_ITEM = Component.m_237115_((String)"tooltip.botanypots.soil_item").m_130940_(ChatFormatting.GREEN);
    private static final Component TOOLTIP_SEED_ITEM = Component.m_237115_((String)"tooltip.botanypots.seed_item").m_130940_(ChatFormatting.GREEN);
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private final ResourceLocation backgroundTexture;

    public BotanyPotScreen(BotanyPotMenu menu, Inventory playerInv, Component name) {
        super((AbstractContainerMenu)menu, playerInv, name);
        this.backgroundTexture = new ResourceLocation("botanypots", "textures/gui/container/" + (menu.isHopper() ? "hopper_botany_pot_gui.png" : "botany_pot_gui.png"));
    }

    public void m_7856_() {
        super.m_7856_();
        int recipeOffset = this.f_97735_ + (((BotanyPotMenu)this.f_97732_).isHopper() ? 13 : 33);
    }

    protected void m_7286_(GuiGraphics graphics, float v, int i, int i1) {
        graphics.m_280218_(this.backgroundTexture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float tickDelta) {
        this.m_280273_(graphics, mouseX, mouseY, tickDelta);
        super.m_88315_(graphics, mouseX, mouseY, tickDelta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected List<Component> m_280553_(ItemStack stack) {
        List tooltips = super.m_280553_(stack);
        if (this.f_96541_ != null) {
            boolean isAdvanced = this.f_96541_.f_91066_.f_92125_;
            BlockEntityBotanyPot pot = ((BotanyPotMenu)this.f_97732_).getPotInventory().getPotEntity();
            Level level = pot.m_58904_();
            BlockPos pos = pot.m_58899_();
            Slot slot = this.f_97734_;
            if (slot instanceof SlotSoil) {
                SlotSoil soilSlot = (SlotSoil)slot;
                if (!pot.isValidSoil(stack)) {
                    tooltips.add(TOOLTIP_INVALID_SOIL);
                } else {
                    Soil soil;
                    soilRecipe = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (soilRecipe != null && (soil = (Soil)soilRecipe.f_291008_()) != null) {
                        if (pot.getCrop() == null) {
                            tooltips.add(TOOLTIP_MISSING_SEED);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, soil, pot.getCrop())) {
                            tooltips.add(TOOLTIP_INCORRECT_SOIL);
                        } else {
                            float growthModifier = soil.getGrowthModifier(level, pos, pot, pot.getCrop());
                            MutableComponent multiplier = Component.m_237113_((String)MULTIPLIER_FORMAT.format(growthModifier)).m_130940_(growthModifier > 1.0f ? ChatFormatting.GREEN : (growthModifier < 1.0f ? ChatFormatting.RED : ChatFormatting.GRAY));
                            tooltips.add(Component.m_237110_((String)"tooltip.botanypots.soil_modifier", (Object[])new Object[]{multiplier}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                }
            } else {
                soilRecipe = this.f_97734_;
                if (soilRecipe instanceof SlotCropSeed) {
                    Crop crop;
                    RecipeHolder<Crop> cropRecipe;
                    SlotCropSeed seedSlot = (SlotCropSeed)soilRecipe;
                    if (!pot.isValidSeed(stack)) {
                        tooltips.add(TOOLTIP_INVALID_CROP);
                    }
                    if ((cropRecipe = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null && (crop = (Crop)cropRecipe.f_291008_()) != null) {
                        if (pot.getSoil() == null) {
                            tooltips.add(TOOLTIP_MISSING_SOIL);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), crop)) {
                            tooltips.add(TOOLTIP_INCORRECT_SEED);
                        }
                    }
                } else {
                    RecipeHolder<Crop> hoveredCrop;
                    RecipeHolder<Soil> hoverSoil = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (hoverSoil != null) {
                        tooltips.add(TOOLTIP_SOIL_ITEM);
                        if (isAdvanced) {
                            tooltips.add(Component.m_237110_((String)"tooltip.botanypots.soil_id", (Object[])new Object[]{hoverSoil.f_291676_().toString()}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                    if ((hoveredCrop = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        tooltips.add(TOOLTIP_SEED_ITEM);
                        if (isAdvanced) {
                            tooltips.add(Component.m_237110_((String)"tooltip.botanypots.crop_id", (Object[])new Object[]{hoveredCrop.f_291676_().toString()}).m_130940_(ChatFormatting.GRAY));
                        }
                    }
                }
            }
        }
        return tooltips;
    }
}

