/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.commands.BotanyPotsCommands;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class CommandDump {
    public static void build(LiteralArgumentBuilder<CommandSourceStack> parent) {
        LiteralArgumentBuilder cmd = Commands.m_82127_((String)"dump");
        cmd.then(Commands.m_82127_((String)"missing_crops").executes(MissingCrops::dump));
        parent.then((ArgumentBuilder)cmd);
    }

    private static class MissingCrops {
        private static final TagKey<Item> FORGE_SEEDS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "seeds"));
        private static final TagKey<Item> COMMON_SEEDS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("c", "seeds"));

        private MissingCrops() {
        }

        private static int dump(CommandContext<CommandSourceStack> ctx) {
            HashSet<Item> missingSeedItems = new HashSet<Item>();
            RecipeManager manager = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_();
            block0: for (Item item2 : BuiltInRegistries.f_257033_) {
                if (MissingCrops.isCrop(item2.m_7968_(), manager) || MissingCrops.isSoil(item2.m_7968_(), manager) || !(item2 instanceof BlockItem)) continue;
                BlockItem itemBlock = (BlockItem)item2;
                Block placedBlock = itemBlock.m_40614_();
                if (placedBlock instanceof CropBlock || placedBlock instanceof GrowingPlantBlock || placedBlock instanceof BonemealableBlock || placedBlock instanceof SaplingBlock || placedBlock instanceof BushBlock) {
                    missingSeedItems.add(item2);
                    continue;
                }
                for (Property property : placedBlock.m_49965_().m_61092_()) {
                    if (!property.m_61708_().equalsIgnoreCase("age")) continue;
                    missingSeedItems.add(item2);
                    continue block0;
                }
            }
            Consumer<Item> tagProcessor = item -> {
                if (!MissingCrops.isCrop(item.m_7968_(), manager)) {
                    missingSeedItems.add((Item)item);
                }
            };
            MissingCrops.processTag(FORGE_SEEDS, tagProcessor);
            MissingCrops.processTag(COMMON_SEEDS, tagProcessor);
            if (missingSeedItems.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> BotanyPotsCommands.modMessage((Component)Component.m_237115_((String)"commands.botanypots.dump.no_results")), false);
            } else {
                StringJoiner entries = new StringJoiner(System.lineSeparator());
                entries.add("Potential missing crop IDs");
                missingSeedItems.stream().sorted(MissingCrops::compareById).forEach(e -> entries.add(BuiltInRegistries.f_257033_.m_7981_(e).toString()));
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> BotanyPotsCommands.modMessage((Component)Component.m_237110_((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{Component.m_237113_((String)Integer.toString(missingSeedItems.size())).m_130938_(style -> style.m_131140_(ChatFormatting.RED))}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, entries.toString())))), false);
            }
            return 0;
        }

        private static void processTag(TagKey<Item> key, Consumer<Item> consumer) {
            BuiltInRegistries.f_257033_.m_203431_(key).ifPresent(named -> named.forEach(entry -> consumer.accept((Item)entry.m_203334_())));
        }

        private static boolean isCrop(ItemStack stack, RecipeManager recipes) {
            for (RecipeHolder recipe : recipes.m_44013_((RecipeType)BotanyPotHelper.CROP_TYPE.get())) {
                if (!((Crop)recipe.f_291008_()).matchesLookup(null, null, null, stack)) continue;
                return true;
            }
            return false;
        }

        private static boolean isSoil(ItemStack stack, RecipeManager recipes) {
            for (RecipeHolder recipe : recipes.m_44013_((RecipeType)BotanyPotHelper.SOIL_TYPE.get())) {
                if (!((Soil)recipe.f_291008_()).matchesLookup(null, null, null, stack)) continue;
                return true;
            }
            return false;
        }

        private static int compareById(Item e1, Item e2) {
            return BuiltInRegistries.f_257033_.m_7981_((Object)e1).toString().compareTo(BuiltInRegistries.f_257033_.m_7981_((Object)e2).toString());
        }
    }
}

