/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.displaystate.render.DisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.types.EntityDisplayState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityDisplayStateRenderer
extends DisplayStateRenderer<EntityDisplayState> {
    public static final EntityDisplayStateRenderer RENDERER = new EntityDisplayStateRenderer();

    private EntityDisplayStateRenderer() {
    }

    @Override
    public void render(BlockEntityRendererProvider.Context context, EntityDisplayState displayState, PoseStack pose, Level level, BlockPos pos, float tickDelta, MultiBufferSource bufferSource, int light, int overlay, BlockEntityBotanyPot pot, float progress) {
        Entity displayEntity = displayState.getOrCreateDisplayEntity(level, level.m_213780_(), pos);
        if (displayEntity != null) {
            if (displayState.shouldTickEntity()) {
                displayEntity.f_19797_ = (int)(level.m_46467_() % Integer.MAX_VALUE);
            }
            pose.m_85836_();
            pose.m_85837_(0.5, 0.0, 0.5);
            displayState.getScale().ifPresent(scale -> pose.m_85841_(scale.x(), scale.y(), scale.z()));
            displayState.getOffset().ifPresent(offset -> pose.m_252880_(offset.x(), offset.y(), offset.z()));
            if (displayState.getSpinSpeed() > 0) {
                pose.m_252781_(Axis.f_252436_.m_252977_(360.0f * (float)displayState.getSpinSpeed() * progress));
            }
            EntityDisplayStateRenderer.renderEntityAndPassengers(context.m_234446_(), displayEntity, tickDelta, pose, bufferSource, light);
            pose.m_85849_();
        }
    }

    private static void renderEntityAndPassengers(EntityRenderDispatcher renderer, Entity parent, float tickDelta, PoseStack pose, MultiBufferSource buffer, int light) {
        renderer.m_114384_(parent, 0.0, 0.0, 0.0, 0.0f, tickDelta, pose, buffer, light);
        for (Entity passenger : parent.m_20197_()) {
            Vec3 passengerPosition = parent.m_292590_(passenger);
            pose.m_85837_(passengerPosition.f_82479_, passengerPosition.f_82480_, passengerPosition.f_82481_);
            EntityDisplayStateRenderer.renderEntityAndPassengers(renderer, passenger, tickDelta, pose, buffer, light);
        }
    }
}

