/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.data.displaystate.DisplayTypes;
import net.darkhax.botanypots.data.displaystate.math.AxisAlignedRotation;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.darkhax.botanypots.data.displaystate.types.PhasedDisplayState;
import net.darkhax.botanypots.data.displaystate.types.SimpleDisplayState;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class AgingDisplayState
extends PhasedDisplayState {
    public static final CodecHelper<AgingDisplayState> CODEC = new CodecHelper(RecordCodecBuilder.create(instance -> instance.group((App)BookshelfCodecs.BLOCK.get("block", state -> state.defaultState.m_60734_()), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties").forGetter(state -> DisplayState.encodeProperties(state.defaultState)), (App)BookshelfCodecs.VECTOR_3F.getOptional("scale", AgingDisplayState::getScale), (App)BookshelfCodecs.VECTOR_3F.getOptional("offset", AgingDisplayState::getOffset), (App)AxisAlignedRotation.CODEC.getList("rotation", AgingDisplayState::getRotations, new ArrayList()), (App)BookshelfCodecs.BOOLEAN.get("renderFluid", AgingDisplayState::shouldRenderFluid, (Object)false)).apply((Applicative)instance, AgingDisplayState::new)), (Object[])new AgingDisplayState[0]);
    public static final ByteBufHelper<AgingDisplayState> BUFFER = new ByteBufHelper(AgingDisplayState::readFromBuffer, AgingDisplayState::writeToBuffer, (Object[])new AgingDisplayState[0]);
    private final BlockState defaultState;
    private final Optional<Vector3f> scale;
    private final Optional<Vector3f> offset;
    private final List<AxisAlignedRotation> rotations;
    private final boolean renderFluid;
    private final List<DisplayState> phases;

    public AgingDisplayState(Block block, Optional<Map<String, String>> properties, Optional<Vector3f> scale, Optional<Vector3f> offset, List<AxisAlignedRotation> rotations, boolean renderFluid) {
        this(AgingDisplayState.decodeBlockState(block, properties), scale, offset, rotations, renderFluid);
    }

    public AgingDisplayState(BlockState defaultState, Optional<Vector3f> scale, Optional<Vector3f> offset, List<AxisAlignedRotation> rotations, boolean renderFluid) {
        this.defaultState = defaultState;
        this.scale = scale;
        this.offset = offset;
        this.rotations = rotations;
        this.renderFluid = renderFluid;
        this.phases = this.calculatePhases(this.defaultState);
    }

    private BlockState getDefaultState() {
        return this.defaultState;
    }

    public Optional<Vector3f> getScale() {
        return this.scale;
    }

    public Optional<Vector3f> getOffset() {
        return this.offset;
    }

    public List<AxisAlignedRotation> getRotations() {
        return this.rotations;
    }

    public boolean shouldRenderFluid() {
        return this.renderFluid;
    }

    private SimpleDisplayState buildPhase(BlockState state) {
        return new SimpleDisplayState(state, this.getScale(), this.getOffset(), this.getRotations(), this.shouldRenderFluid());
    }

    private List<DisplayState> calculatePhases(BlockState defaultState) {
        Block block = defaultState.m_60734_();
        ArrayList<DisplayState> phases = new ArrayList<DisplayState>();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            for (int i = 0; i < crop.m_7419_(); ++i) {
                try {
                    BlockState agedState = crop.m_52289_(i);
                    if (agedState == null) continue;
                    phases.add(this.buildPhase(agedState));
                    continue;
                }
                catch (Exception e) {
                    Constants.LOG.error("Invalid crop age found! state={} age={}", (Object)defaultState, (Object)i);
                    Constants.LOG.error("Error: ", (Throwable)e);
                }
            }
        } else {
            Property ageProperty = block.m_49965_().m_61081_("age");
            if (ageProperty instanceof IntegerProperty) {
                IntegerProperty intProperty = (IntegerProperty)ageProperty;
                Iterator iterator = intProperty.m_6908_().iterator();
                while (iterator.hasNext()) {
                    int age = (Integer)iterator.next();
                    phases.add(this.buildPhase((BlockState)defaultState.m_61124_((Property)intProperty, (Comparable)Integer.valueOf(age))));
                }
            } else {
                phases.add(this.buildPhase(defaultState));
            }
        }
        return phases;
    }

    @Override
    public DisplayTypes.DisplayType<?> getType() {
        return DisplayTypes.AGING;
    }

    private static AgingDisplayState readFromBuffer(FriendlyByteBuf buffer) {
        BlockState defaultState = (BlockState)BookshelfByteBufs.BLOCK_STATE.read(buffer);
        Optional scale = BookshelfByteBufs.VECTOR_3F.readOptional(buffer);
        Optional offset = BookshelfByteBufs.VECTOR_3F.readOptional(buffer);
        List rotations = AxisAlignedRotation.BUFFER.readList(buffer);
        boolean renderFluid = (Boolean)BookshelfByteBufs.BOOLEAN.read(buffer);
        return new AgingDisplayState(defaultState, scale, offset, rotations, renderFluid);
    }

    private static void writeToBuffer(FriendlyByteBuf buffer, AgingDisplayState toWrite) {
        BookshelfByteBufs.BLOCK_STATE.write(buffer, (Object)toWrite.getDefaultState());
        BookshelfByteBufs.VECTOR_3F.writeOptional(buffer, toWrite.getScale());
        BookshelfByteBufs.VECTOR_3F.writeOptional(buffer, toWrite.getOffset());
        AxisAlignedRotation.BUFFER.writeList(buffer, toWrite.getRotations());
        BookshelfByteBufs.BOOLEAN.write(buffer, (Object)toWrite.shouldRenderFluid());
    }

    @Override
    public List<DisplayState> getDisplayPhases() {
        return this.phases;
    }
}

