/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.data.displaystate.DisplayTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DisplayState {
    public abstract DisplayTypes.DisplayType<?> getType();

    public static Optional<Map<String, String>> encodeProperties(BlockState state) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry entry : state.m_61148_().entrySet()) {
            propertyMap.put(((Property)entry.getKey()).m_61708_(), ((Property)entry.getKey()).m_6940_((Comparable)entry.getValue()));
        }
        return Optional.ofNullable(propertyMap.isEmpty() ? null : propertyMap);
    }

    public static BlockState decodeBlockState(Block block, Optional<Map<String, String>> properties) {
        BlockState state = block.m_49966_();
        if (properties.isPresent()) {
            StateDefinition definition = block.m_49965_();
            for (Map.Entry<String, String> entry : properties.get().entrySet()) {
                Property property = definition.m_61081_(entry.getKey());
                if (property != null) {
                    Optional value = property.m_6215_(entry.getValue());
                    if (value.isPresent()) {
                        try {
                            state = (BlockState)state.m_61124_(property, (Comparable)value.get());
                            continue;
                        }
                        catch (Exception e) {
                            Constants.LOG.error("Failed to update state for block {} with valid value {}={}. The mod that adds this block may have a serious issue.", new Object[]{BuiltInRegistries.f_256975_.m_7981_((Object)block), entry.getKey(), entry.getValue()});
                            return state;
                        }
                    }
                    Constants.LOG.error("\"{}\" is not a valid value for property \"{}\" on block \"{}\". Available values: {}", new Object[]{entry.getValue(), property.m_61708_(), BuiltInRegistries.f_256975_.m_7981_((Object)block), property.m_61702_().map(propVal -> property.m_6940_(propVal.f_61713_())).collect(Collectors.joining())});
                    return state;
                }
                Constants.LOG.error("The property \"{}\" is not valid for block \"{}\". Available properties: {}", new Object[]{entry.getKey(), BuiltInRegistries.f_256975_.m_7981_((Object)block), definition.m_61092_().stream().map(Property::m_61708_).collect(Collectors.joining())});
                return state;
            }
        }
        return state;
    }
}

