/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.crop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.util.MathsHelper;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.crop.HarvestEntry;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BasicCrop
extends Crop {
    protected Ingredient seed;
    protected Set<String> soilCategories;
    protected int growthTicks;
    protected List<HarvestEntry> results;
    protected List<DisplayState> displayStates;
    protected int lightLevel;

    public BasicCrop(Ingredient seed, Set<String> soilCategories, int growthTicks, List<DisplayState> displayStates, int lightLevel) {
        this(seed, soilCategories, growthTicks, new ArrayList<HarvestEntry>(), displayStates, lightLevel);
    }

    public BasicCrop(Ingredient seed, Set<String> soilCategories, int growthTicks, List<HarvestEntry> results, List<DisplayState> displayStates, int lightLevel) {
        this.seed = seed;
        this.soilCategories = soilCategories;
        this.growthTicks = growthTicks;
        this.results = results;
        this.displayStates = displayStates;
        this.lightLevel = lightLevel;
    }

    @Override
    public boolean matchesLookup(Level level, BlockPos pos, BlockEntityBotanyPot pot, ItemStack placedStack) {
        Soil soil;
        if (pot != null && (soil = pot.getSoil()) != null && !BotanyPotHelper.canCropGrow(level, pos, pot, soil, (Crop)this)) {
            return false;
        }
        return this.seed.test(placedStack);
    }

    @Override
    public int getGrowthTicks(Level level, BlockPos pos, BlockEntityBotanyPot pot, @Nullable Soil soil) {
        return this.growthTicks;
    }

    @Override
    public int getLightLevel(Level level, BlockPos pos, BlockEntityBotanyPot pot) {
        return this.lightLevel;
    }

    @Override
    public boolean canGrowInSoil(Level level, BlockPos pos, BlockEntityBotanyPot pot, Soil soil) {
        for (String soilCategory : soil.getCategories(level, pos, pot)) {
            for (String cropCategory : this.getCategories(level, pos, pot)) {
                if (!soilCategory.equalsIgnoreCase(cropCategory)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getCategories(Level level, BlockPos pos, BlockEntityBotanyPot pot) {
        return this.soilCategories;
    }

    @Override
    public List<DisplayState> getDisplayState(Level level, BlockPos pos, BlockEntityBotanyPot pot) {
        return this.displayStates;
    }

    @Override
    public List<ItemStack> generateDrops(Random rng, Level level, BlockPos pos, BlockEntityBotanyPot pot) {
        NonNullList drops = NonNullList.m_122779_();
        for (HarvestEntry cropEntry : this.results) {
            int rolls;
            if (!(rng.nextFloat() <= cropEntry.getChance()) || (rolls = MathsHelper.nextIntInclusive((Random)rng, (int)cropEntry.getMinRolls(), (int)cropEntry.getMaxRolls())) <= 0) continue;
            for (int roll = 0; roll < rolls; ++roll) {
                drops.add((Object)cropEntry.getItem().m_41777_());
            }
        }
        return drops;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BotanyPotHelper.CROP_SERIALIZER.get();
    }

    public Ingredient getSeed() {
        return this.seed;
    }

    public Set<String> getSoilCategories() {
        return Collections.unmodifiableSet(this.soilCategories);
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    public List<HarvestEntry> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public List<DisplayState> getDisplayStates() {
        return Collections.unmodifiableList(this.displayStates);
    }

    public int getLightLevel() {
        return this.lightLevel;
    }
}

