/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.crop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class HarvestEntry {
    public static CodecHelper<HarvestEntry> CODEC = new CodecHelper(RecordCodecBuilder.create(instance -> instance.group((App)BookshelfCodecs.FLOAT.get("chance", HarvestEntry::getChance, (Object)Float.valueOf(1.0f)), (App)BookshelfCodecs.ITEM_STACK_FLEXIBLE.get("output", HarvestEntry::getItem), (App)BookshelfCodecs.INT.get("minRolls", HarvestEntry::getMinRolls, (Object)1), (App)BookshelfCodecs.INT.get("maxRolls", HarvestEntry::getMaxRolls, (Object)1)).apply((Applicative)instance, HarvestEntry::new)), (Object[])new HarvestEntry[0]);
    public static ByteBufHelper<HarvestEntry> BUFFER = new ByteBufHelper(HarvestEntry::read, HarvestEntry::write, (Object[])new HarvestEntry[0]);
    private final float chance;
    private final ItemStack item;
    private final int minRolls;
    private final int maxRolls;

    public HarvestEntry(float chance, ItemStack item, int minRolls, int maxRolls) {
        this.chance = chance;
        this.item = item;
        this.minRolls = minRolls;
        this.maxRolls = maxRolls;
        if (minRolls < 0 || maxRolls < 0) {
            throw new IllegalArgumentException("Rolls must not be negative!");
        }
        if (minRolls > maxRolls) {
            throw new IllegalArgumentException("Min rolls must not be greater than max rolls!");
        }
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getMinRolls() {
        return this.minRolls;
    }

    public int getMaxRolls() {
        return this.maxRolls;
    }

    public static HarvestEntry read(FriendlyByteBuf buffer) {
        float chance = ((Float)BookshelfByteBufs.FLOAT.read(buffer)).floatValue();
        ItemStack output = (ItemStack)BookshelfByteBufs.ITEM_STACK.read(buffer);
        int min = (Integer)BookshelfByteBufs.INT.read(buffer);
        int max = (Integer)BookshelfByteBufs.INT.read(buffer);
        return new HarvestEntry(chance, output, min, max);
    }

    public static void write(FriendlyByteBuf buffer, HarvestEntry entry) {
        BookshelfByteBufs.FLOAT.write(buffer, (Object)Float.valueOf(entry.chance));
        BookshelfByteBufs.ITEM_STACK.write(buffer, (Object)entry.item);
        BookshelfByteBufs.INT.write(buffer, (Object)entry.minRolls);
        BookshelfByteBufs.INT.write(buffer, (Object)entry.maxRolls);
    }
}

