/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.potinteraction;

import java.util.List;
import java.util.Optional;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BasicPotInteraction
extends PotInteraction {
    protected final Ingredient heldTest;
    protected final boolean damageHeld;
    protected final Optional<Ingredient> soilTest;
    protected final Optional<Ingredient> seedTest;
    protected final Optional<ItemStack> newSoilStack;
    protected final Optional<ItemStack> newSeedStack;
    protected final Optional<Sound> sound;
    protected final List<ItemStack> extraDrops;

    public BasicPotInteraction(Ingredient heldTest, boolean damageHeld, Optional<Ingredient> soilTest, Optional<Ingredient> seedTest, Optional<ItemStack> newSoilStack, Optional<ItemStack> newSeedStack, Optional<Sound> sound, List<ItemStack> extraDrops) {
        this.heldTest = heldTest;
        this.damageHeld = damageHeld;
        this.soilTest = soilTest;
        this.seedTest = seedTest;
        this.newSoilStack = newSoilStack;
        this.newSeedStack = newSeedStack;
        this.sound = sound;
        this.extraDrops = extraDrops;
    }

    @Override
    public boolean canApply(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        return !(!this.heldTest.test(heldStack) || !this.soilTest.isEmpty() && !this.soilTest.get().test(((BotanyPotContainer)pot.getInventory()).getSoilStack()) || !this.seedTest.isEmpty() && !this.seedTest.get().test(((BotanyPotContainer)pot.getInventory()).getCropStack()));
    }

    @Override
    public void apply(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack heldStack, BlockEntityBotanyPot pot) {
        if (!world.f_46443_) {
            this.newSoilStack.ifPresent(soilStack -> {
                ItemStack dropStack;
                if (Services.INVENTORY_HELPER.hasCraftingRemainder(((BotanyPotContainer)pot.getInventory()).getSoilStack()) && (dropStack = Services.INVENTORY_HELPER.getCraftingRemainder(((BotanyPotContainer)pot.getInventory()).getSoilStack())) != null) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropStack.m_41777_());
                }
                ((BotanyPotContainer)pot.getInventory()).m_6836_(0, soilStack.m_41777_());
            });
            this.newSeedStack.ifPresent(seedStack -> {
                ItemStack dropStack;
                if (Services.INVENTORY_HELPER.hasCraftingRemainder(((BotanyPotContainer)pot.getInventory()).getCropStack()) && (dropStack = Services.INVENTORY_HELPER.getCraftingRemainder(((BotanyPotContainer)pot.getInventory()).getCropStack())) != null) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropStack.m_41777_());
                }
                ((BotanyPotContainer)pot.getInventory()).m_6836_(1, seedStack.m_41777_());
            });
            if (this.damageHeld && heldStack.m_41776_() > 0) {
                Services.INVENTORY_HELPER.damageStack(heldStack, 1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            } else {
                ItemStack remainder = Services.INVENTORY_HELPER.getCraftingRemainder(heldStack);
                if (!remainder.m_41619_()) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)remainder.m_41777_());
                }
                heldStack.m_41774_(1);
            }
            if (this.extraDrops != null && !this.extraDrops.isEmpty()) {
                for (ItemStack drop : this.extraDrops) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop.m_41777_());
                }
            }
        }
        this.sound.ifPresent(harvestSound -> harvestSound.playSoundAt(world, player, pos));
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BotanyPotHelper.SIMPLE_POT_INTERACTION_SERIALIZER.get();
    }

    public Ingredient getHeldTest() {
        return this.heldTest;
    }

    public boolean isDamageHeld() {
        return this.damageHeld;
    }

    public Optional<Ingredient> getSoilTest() {
        return this.soilTest;
    }

    public Optional<Ingredient> getSeedTest() {
        return this.seedTest;
    }

    public Optional<ItemStack> getNewSoilStack() {
        return this.newSoilStack;
    }

    public Optional<ItemStack> getNewSeedStack() {
        return this.newSeedStack;
    }

    public Optional<Sound> getSound() {
        return this.sound;
    }

    public List<ItemStack> getExtraDrops() {
        return this.extraDrops;
    }
}

