/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.data.displaystate.math.AxisAlignedRotation;
import net.darkhax.botanypots.data.displaystate.render.DisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class BotanyPotRenderer
implements class_827<BlockEntityBotanyPot> {
    private final class_5614.class_5615 renderContext;

    public BotanyPotRenderer(class_5614.class_5615 ctx) {
        this.renderContext = ctx;
    }

    private static AxisAlignedRotation rotateFacing(class_2350 facing) {
        if (facing == class_2350.field_11034) {
            return AxisAlignedRotation.Y_90;
        }
        if (facing == class_2350.field_11043) {
            return AxisAlignedRotation.Y_180;
        }
        if (facing == class_2350.field_11039) {
            return AxisAlignedRotation.Y_270;
        }
        return null;
    }

    public static void applyRotation(AxisAlignedRotation rotation, class_4587 pose) {
        pose.method_22907(rotation.rotation);
        pose.method_46416(rotation.offset.x(), rotation.offset.y(), rotation.offset.z());
    }

    public void render(BlockEntityBotanyPot pot, float tickDelta, class_4587 pose, class_4597 bufferSource, int light, int overlay) {
        if (pot.getSoil() != null) {
            class_1937 level = pot.method_10997();
            class_2338 pos = pot.method_11016();
            int maxGrowth = ((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
            float partialOffset = pot.getGrowthTime() < maxGrowth ? tickDelta : 0.0f;
            float growthProgress = Math.max(((float)pot.getGrowthTime() + partialOffset) / (float)maxGrowth, 0.0f);
            AxisAlignedRotation potRotation = BotanyPotRenderer.rotateFacing((class_2350)pot.method_11010().method_11654((class_2769)class_2741.field_12481));
            pose.method_22903();
            if (potRotation != null) {
                BotanyPotRenderer.applyRotation(potRotation, pose);
            }
            pose.method_22905(0.625f, 0.375f, 0.625f);
            pose.method_22904(0.3, 0.0625, 0.3);
            DisplayStateRenderer.renderState(this.renderContext, pot.getSoil().getDisplayState(level, pos, pot), pose, level, pos, partialOffset, bufferSource, light, overlay, pot, growthProgress);
            pose.method_22909();
            if (pot.getCrop() != null && BotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), pot.getCrop())) {
                pose.method_22903();
                if (potRotation != null) {
                    BotanyPotRenderer.applyRotation(potRotation, pose);
                }
                pose.method_22904(0.5, 0.40625, 0.5);
                float cropScale = class_3532.method_15363((float)((0.4f + growthProgress * 0.6f) * 0.625f), (float)0.15625f, (float)0.625f);
                pose.method_22905(cropScale, cropScale, cropScale);
                pose.method_22904(-0.5, 0.0, -0.5);
                int previousBlocks = 0;
                for (DisplayState state : pot.getCrop().getDisplayState(level, pos, pot)) {
                    if (previousBlocks > 0) {
                        pose.method_46416(0.0f, 1.0f, 0.0f);
                    }
                    pose.method_22903();
                    DisplayStateRenderer.renderState(this.renderContext, state, pose, pot.method_10997(), pot.method_11016(), partialOffset, bufferSource, light, overlay, pot, growthProgress);
                    pose.method_22909();
                    ++previousBlocks;
                }
                pose.method_22909();
            }
        }
    }
}

