/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_8786;

public class BotanyPotContainer
extends class_1277
implements class_1278 {
    public static final int SOIL_SLOT = 0;
    public static final int CROP_SLOT = 1;
    public static final int[] STORAGE_SLOT = IntStream.range(2, 14).toArray();
    public static final int[] EMPTY_SLOTS = new int[0];
    private final BlockEntityBotanyPot potEntity;
    @Nullable
    private class_8786<Soil> soil = null;
    @Nullable
    private class_8786<Crop> crop = null;
    private int requiredGrowthTime = -1;

    public BotanyPotContainer(BlockEntityBotanyPot potEntity) {
        super(14);
        this.potEntity = potEntity;
    }

    public class_1799 getSoilStack() {
        return this.method_5438(0);
    }

    public class_1799 getCropStack() {
        return this.method_5438(1);
    }

    public int getRequiredGrowthTime() {
        return this.requiredGrowthTime;
    }

    public BlockEntityBotanyPot getPotEntity() {
        return this.potEntity;
    }

    public void update() {
        boolean revalidateCrop;
        class_1937 level = this.potEntity.method_10997();
        class_2338 pos = this.potEntity.method_11016();
        boolean revalidateSoil = this.soil == null && !this.getSoilStack().method_7960() && BotanyPotHelper.findSoil(level, pos, this.potEntity, this.getSoilStack()) != null;
        boolean bl = revalidateCrop = this.crop == null && !this.getCropStack().method_7960() && BotanyPotHelper.findCrop(level, pos, this.potEntity, this.getCropStack()) != null;
        if (revalidateSoil || revalidateCrop) {
            this.method_5431();
        }
    }

    public void method_5431() {
        super.method_5431();
        class_1937 level = this.potEntity.method_10997();
        class_2338 pos = this.potEntity.method_11016();
        this.soil = BotanyPotHelper.findSoil(level, pos, this.potEntity, this.getSoilStack());
        this.crop = BotanyPotHelper.findCrop(level, pos, this.potEntity, this.getCropStack());
        this.requiredGrowthTime = BotanyPotHelper.getRequiredGrowthTicks(this.potEntity.method_10997(), this.potEntity.method_11016(), this.potEntity, this.crop, this.soil);
        int potLight = this.getPotEntity().getLightLevel();
        if (this.getPotEntity().method_10997() != null && (Integer)this.getPotEntity().method_11010().method_11654((class_2769)class_2741.field_12538) != potLight) {
            this.getPotEntity().method_10997().method_8652(this.potEntity.method_11016(), (class_2680)this.getPotEntity().method_11010().method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(potLight)), 3);
        }
        this.getPotEntity().markDirty();
    }

    @Nullable
    public class_8786<Crop> getCrop() {
        return this.crop;
    }

    @Nullable
    public class_8786<Soil> getSoil() {
        return this.soil;
    }

    public boolean method_5437(int slotId, class_1799 toPlace) {
        class_1937 level = this.potEntity.method_10997();
        class_2338 pos = this.potEntity.method_11016();
        if (slotId == 0 && this.method_5438(slotId).method_7960()) {
            return BotanyPotHelper.findSoil(level, pos, this.potEntity, toPlace) != null;
        }
        if (slotId == 1 && this.method_5438(slotId).method_7960()) {
            return BotanyPotHelper.findCrop(level, pos, this.potEntity, toPlace) != null;
        }
        return false;
    }

    public int[] method_5494(class_2350 side) {
        return side == class_2350.field_11033 ? STORAGE_SLOT : EMPTY_SLOTS;
    }

    public boolean method_5492(int slotId, class_1799 toInsert, class_2350 side) {
        return false;
    }

    public boolean method_5493(int slotId, class_1799 toExtract, class_2350 side) {
        return side == class_2350.field_11033 && this.potEntity.isHopper() && slotId != 0 && slotId != 1;
    }

    public boolean method_5443(class_1657 player) {
        if (this.potEntity == null || this.potEntity.method_11015()) {
            return false;
        }
        class_2338 pos = this.potEntity.method_11016();
        return player.method_5649((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f)) <= 24.0;
    }
}

