/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.data.displaystate.types.AgingDisplayState;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.darkhax.botanypots.data.displaystate.types.EntityDisplayState;
import net.darkhax.botanypots.data.displaystate.types.SimpleDisplayState;
import net.darkhax.botanypots.data.displaystate.types.TransitionalDisplayState;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class DisplayTypes {
    private static final Map<class_2960, DisplayType<? extends DisplayState>> DISPLAY_TYPES = new HashMap<class_2960, DisplayType<? extends DisplayState>>();
    public static final CodecHelper<DisplayType<? extends DisplayState>> DISPLAY_TYPE_CODEC = new CodecHelper(class_2960.field_25139.xmap(id -> DISPLAY_TYPES.containsKey(id) ? DISPLAY_TYPES.get(id) : DISPLAY_TYPES.get(Constants.id("aging")), DisplayType::id), (Object[])new DisplayType[0]);
    public static final ByteBufHelper<DisplayType<?>> DISPLAY_TYPE_BUFFER = new ByteBufHelper(DisplayType::readFromBuffer, DisplayType::writeToBuffer, (Object[])new DisplayType[0]);
    public static final Codec<DisplayState> DISPLAY_STATE_DISPATCH = BookshelfCodecs.dispatchFallback((Codec)DISPLAY_TYPE_CODEC.get(), DisplayState::getType, displayType -> displayType.getCodec(), () -> DisplayTypes.DISPLAY_TYPES.get((Object)Constants.id((String)"aging")).codec.get());
    public static final CodecHelper<DisplayState> DISPLAY_STATE_CODEC = new CodecHelper(DISPLAY_STATE_DISPATCH, (Object[])new DisplayState[0]);
    public static final ByteBufHelper<DisplayState> DISPLAY_STATE_BUFFER = new ByteBufHelper(DisplayTypes::readFromBuffer, DisplayTypes::writeToBuffer, (Object[])new DisplayState[0]);
    public static final DisplayType<SimpleDisplayState> SIMPLE = DisplayTypes.register(Constants.id("simple"), SimpleDisplayState.CODEC, SimpleDisplayState.BUFFER);
    public static final DisplayType<TransitionalDisplayState> TRANSITIONAL = DisplayTypes.register(Constants.id("transitional"), TransitionalDisplayState.CODEC, TransitionalDisplayState.BUFFER);
    public static final DisplayType<AgingDisplayState> AGING = DisplayTypes.register(Constants.id("aging"), AgingDisplayState.CODEC, AgingDisplayState.BUFFER);
    public static final DisplayType<EntityDisplayState> ENTITY = DisplayTypes.register(Constants.id("entity"), EntityDisplayState.CODEC, EntityDisplayState.BUFFER);

    public static <T extends DisplayState> DisplayType<T> register(class_2960 id, CodecHelper<T> codec, ByteBufHelper<T> buffer) {
        DisplayType<T> type = new DisplayType<T>(id, codec, buffer);
        if (DISPLAY_TYPES.containsKey(id)) {
            Constants.LOG.warn("Display type ID {} has already been assigned to {}. Replacing with {}.", new Object[]{id, DISPLAY_TYPES.get(id), type});
        }
        DISPLAY_TYPES.put(id, type);
        return type;
    }

    private static DisplayState readFromBuffer(class_2540 buffer) {
        DisplayType type = (DisplayType)DISPLAY_TYPE_BUFFER.read(buffer);
        return (DisplayState)type.buffer.read(buffer);
    }

    private static void writeToBuffer(class_2540 buffer, DisplayState toWrite) {
        DISPLAY_TYPE_BUFFER.write(buffer, toWrite.getType());
        toWrite.getType().buffer.write(buffer, (Object)toWrite);
    }

    public record DisplayType<T extends DisplayState>(class_2960 id, CodecHelper<T> codec, ByteBufHelper<T> buffer) {
        @Override
        public String toString() {
            return "DisplayType{id=" + this.id + ", codec=" + this.codec + ", buffer=" + this.buffer + "}";
        }

        public Codec<T> getCodec() {
            return this.codec.get();
        }

        private static DisplayType<?> readFromBuffer(class_2540 buffer) {
            class_2960 id = (class_2960)BookshelfByteBufs.RESOURCE_LOCATION.read(buffer);
            return DISPLAY_TYPES.get(id);
        }

        private static void writeToBuffer(class_2540 buffer, DisplayType<?> toWrite) {
            BookshelfByteBufs.RESOURCE_LOCATION.write(buffer, (Object)toWrite.id);
        }
    }
}

