/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.render;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.displaystate.DisplayTypes;
import net.darkhax.botanypots.data.displaystate.render.EntityDisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.render.PhasedDisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.render.SimpleDisplayStateRenderer;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public abstract class DisplayStateRenderer<T extends DisplayState> {
    private static final Map<DisplayTypes.DisplayType<?>, DisplayStateRenderer<?>> RENDERERS = new HashMap();

    public static DisplayStateRenderer<?> getRenderer(DisplayState state) {
        DisplayStateRenderer<?> renderer = RENDERERS.get(state.getType());
        if (renderer == null) {
            throw new IllegalStateException("Display state " + state.getType().id() + " is not bound to a renderer.");
        }
        return renderer;
    }

    public static void renderState(class_5614.class_5615 context, DisplayState displayState, class_4587 stack, class_1937 level, class_2338 pos, float tickDelta, class_4597 bufferSource, int light, int overlay, BlockEntityBotanyPot pot, float progress) {
        DisplayStateRenderer.getRenderer(displayState).render(context, displayState, stack, level, pos, tickDelta, bufferSource, light, overlay, pot, progress);
    }

    public abstract void render(class_5614.class_5615 var1, T var2, class_4587 var3, class_1937 var4, class_2338 var5, float var6, class_4597 var7, int var8, int var9, BlockEntityBotanyPot var10, float var11);

    public static void init() {
        RENDERERS.put(DisplayTypes.SIMPLE, SimpleDisplayStateRenderer.RENDERER);
        RENDERERS.put(DisplayTypes.TRANSITIONAL, PhasedDisplayStateRenderer.TRANSITIONAL);
        RENDERERS.put(DisplayTypes.AGING, PhasedDisplayStateRenderer.AGING);
        RENDERERS.put(DisplayTypes.ENTITY, EntityDisplayStateRenderer.RENDERER);
    }
}

