/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.fertilizer;

import com.google.gson.JsonParseException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class BasicFertilizer
extends Fertilizer {
    protected class_1856 ingredient;
    protected Optional<class_1856> cropIngredient;
    protected Optional<class_1856> soilIngredient;
    protected int minTicks;
    protected int maxTicks;

    public BasicFertilizer(class_1856 ingredient, Optional<class_1856> cropIngredient, Optional<class_1856> soilIngredient, int minTicks, int maxTicks) {
        if (minTicks < 0 || maxTicks < 0) {
            throw new JsonParseException("Growth ticks must be greater than 0! min=" + minTicks + " max=" + maxTicks);
        }
        if (minTicks > maxTicks) {
            throw new JsonParseException("Min growth ticks must not be greater than max ticks.  min=" + minTicks + " max=" + maxTicks);
        }
        this.ingredient = ingredient;
        this.cropIngredient = cropIngredient;
        this.soilIngredient = soilIngredient;
        this.minTicks = minTicks;
        this.maxTicks = maxTicks;
    }

    @Override
    public boolean canApply(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 heldStack, BlockEntityBotanyPot pot) {
        return !(!this.ingredient.method_8093(heldStack) || this.cropIngredient.isPresent() && !this.cropIngredient.get().method_8093(((BotanyPotContainer)pot.getInventory()).getCropStack()) || this.soilIngredient.isPresent() && !this.soilIngredient.get().method_8093(((BotanyPotContainer)pot.getInventory()).getSoilStack()));
    }

    @Override
    public void apply(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 heldStack, BlockEntityBotanyPot pot) {
        if (!world.field_9236) {
            pot.addGrowth(world.field_9229.method_39332(this.minTicks, this.maxTicks));
            world.method_20290(1505, pos, 0);
            if (!player.method_7337()) {
                heldStack.method_7934(1);
            }
        }
    }

    public class_1865<?> method_8119() {
        return (class_1865)BotanyPotHelper.BASIC_FERTILIZER_SERIALIZER.get();
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public Optional<class_1856> getCropIngredient() {
        return this.cropIngredient;
    }

    @Nullable
    public Optional<class_1856> getSoilIngredient() {
        return this.soilIngredient;
    }

    public int getMinTicks() {
        return this.minTicks;
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }
}

